/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.application.action.app;

import java.lang.module.ModuleReference;
import java.lang.module.ResolvedModule;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javafx.event.ActionEvent;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.TextArea;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javafx.stage.Window;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.application.Application;
import org.jhotdraw8.application.ApplicationLabels;
import org.jhotdraw8.application.action.AbstractApplicationAction;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;

public class AboutAction
extends AbstractApplicationAction {
    public static final String ID = "application.about";

    public AboutAction(@NonNull Application app) {
        super(app);
        ApplicationLabels.getResources().configureAction(this, ID);
    }

    @Override
    protected void onActionPerformed(@NonNull ActionEvent event, @NonNull Application app) {
        String name = (String)app.get((MapAccessor)Application.NAME_KEY);
        String version = (String)app.get((MapAccessor)Application.VERSION_KEY);
        String vendor = (String)app.get((MapAccessor)Application.COPYRIGHT_KEY);
        String license = (String)app.get((MapAccessor)Application.LICENSE_KEY);
        Alert alert = new Alert(Alert.AlertType.INFORMATION);
        VBox graphic = new VBox();
        TextArea textArea = new TextArea((name == null ? "unnamed" : name) + (String)(version == null ? "" : " " + version) + (String)(vendor == null ? "" : "\n" + vendor) + (String)(license == null ? "" : "\n" + license) + "\n\nRunning on\n  Java: " + System.getProperty("java.version") + ", " + System.getProperty("java.vendor") + "\n  JVM: " + System.getProperty("java.vm.version") + ", " + System.getProperty("java.vm.vendor") + "\n  OS: " + System.getProperty("os.name") + " " + System.getProperty("os.version") + ", " + System.getProperty("os.arch") + "\n\nModules:\n" + this.getDependencies());
        textArea.setEditable(false);
        graphic.getChildren().add((Object)textArea);
        alert.setGraphic((Node)graphic);
        alert.getDialogPane().setMaxWidth(640.0);
        alert.setHeaderText("");
        if (event.getSource() instanceof Node) {
            Scene scene = ((Node)event.getSource()).getScene();
            Window window = scene == null ? null : scene.getWindow();
            alert.initOwner(window);
            alert.initModality(Modality.WINDOW_MODAL);
        }
        alert.getDialogPane().getScene().getStylesheets().addAll(this.getApplication().getStylesheets());
        alert.show();
    }

    private @NonNull String getDependencies() {
        Pattern pattern = Pattern.compile("-(\\w+(?:[.\\-+]\\w+)*).jar$");
        return ModuleLayer.boot().modules().stream().map(m -> {
            if (m.getDescriptor().version().isPresent()) {
                return m.getDescriptor().toNameAndVersion();
            }
            String version = m.getLayer().configuration().findModule(m.getName()).map(ResolvedModule::reference).map(ModuleReference::location).flatMap(Function.identity()).map(uri -> {
                Matcher matcher = pattern.matcher(uri.getPath());
                return matcher.find() ? matcher.group(1) : null;
            }).orElse(null);
            return version == null ? m.getName() : m.getName() + "@" + version;
        }).filter(str -> !str.startsWith("java.") && !str.startsWith("jdk.")).sorted().collect(Collectors.joining("\n  ", "  ", ""));
    }
}

