/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.application.action.file;

import java.lang.reflect.Type;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.event.ActionEvent;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.TextArea;
import javafx.scene.input.DataFormat;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.application.Activity;
import org.jhotdraw8.application.Application;
import org.jhotdraw8.application.ApplicationLabels;
import org.jhotdraw8.application.FileBasedActivity;
import org.jhotdraw8.application.FileBasedApplication;
import org.jhotdraw8.application.action.AbstractApplicationAction;
import org.jhotdraw8.application.controls.urichooser.FileURIChooser;
import org.jhotdraw8.application.controls.urichooser.URIChooser;
import org.jhotdraw8.application.resources.Resources;
import org.jhotdraw8.base.net.UriUtil;
import org.jhotdraw8.fxbase.concurrent.SimpleWorkState;
import org.jhotdraw8.fxbase.concurrent.WorkState;
import org.jhotdraw8.fxcollection.typesafekey.Key;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jhotdraw8.fxcollection.typesafekey.NonNullMapAccessor;
import org.jhotdraw8.fxcollection.typesafekey.NullableObjectKey;
import org.jhotdraw8.fxcollection.typesafekey.SimpleParameterizedType;
import org.jhotdraw8.icollection.ChampMap;
import org.jhotdraw8.icollection.immutable.ImmutableMap;

public abstract class AbstractOpenFileAction
extends AbstractApplicationAction {
    public static final @NonNull Key<URIChooser> OPEN_CHOOSER_KEY = new NullableObjectKey("openChooser", URIChooser.class);
    public static final @NonNull Key<Supplier<URIChooser>> OPEN_CHOOSER_FACTORY_KEY = new NullableObjectKey("openChooserFactory", (Type)new SimpleParameterizedType(Supplier.class, new Type[]{URIChooser.class}));

    public AbstractOpenFileAction(@NonNull FileBasedApplication app) {
        super(app);
    }

    protected @Nullable URIChooser getChooser(FileBasedActivity view) {
        URIChooser chooser = (URIChooser)this.app.get((MapAccessor)OPEN_CHOOSER_KEY);
        if (chooser == null) {
            Supplier factory = (Supplier)this.app.get((MapAccessor)OPEN_CHOOSER_FACTORY_KEY);
            chooser = factory == null ? new FileURIChooser() : (URIChooser)factory.get();
            this.app.set((MapAccessor)OPEN_CHOOSER_KEY, chooser);
        }
        return chooser;
    }

    protected abstract boolean isReuseEmptyViews();

    @Override
    protected void onActionPerformed(@NonNull ActionEvent evt, @NonNull Application app) {
        FileBasedActivity emptyView;
        SimpleWorkState workState = new SimpleWorkState(this.getLabel());
        app.addDisabler(workState);
        if (this.isReuseEmptyViews()) {
            emptyView = (FileBasedActivity)app.getActiveActivity();
            if (emptyView == null || !emptyView.isEmpty() || emptyView.isDisabled()) {
                emptyView = null;
            }
        } else {
            emptyView = null;
        }
        if (emptyView == null) {
            app.createActivity().thenAccept(arg_0 -> this.lambda$onActionPerformed$0((WorkState)workState, arg_0));
        } else {
            this.doIt(emptyView, false, (WorkState<Void>)workState);
        }
    }

    public void doIt(@NonNull FileBasedActivity view, boolean disposeView, WorkState<Void> workState) {
        URIChooser chooser = this.getChooser(view);
        URI uri = chooser.showDialog(this.app.getNode());
        if (uri != null) {
            this.app.getActivities().add((Object)view);
            if (!((Boolean)this.getApplication().getNonNull((NonNullMapAccessor)FileBasedApplication.ALLOW_MULTIPLE_ACTIVITIES_WITH_SAME_URI)).booleanValue()) {
                for (Activity vp : this.getApplication().getActivities()) {
                    FileBasedActivity v = (FileBasedActivity)vp;
                    if (v.getURI() == null || !v.getURI().equals(uri)) continue;
                    if (disposeView) {
                        this.app.getActivities().remove((Object)view);
                    }
                    this.app.removeDisabler(workState);
                    v.getNode().getScene().getWindow().requestFocus();
                    v.getNode().requestFocus();
                    return;
                }
            }
            this.openActivityFromURI(view, uri, chooser, workState);
        } else {
            if (disposeView) {
                this.app.getActivities().remove((Object)view);
            }
            this.app.removeDisabler(workState);
        }
    }

    protected void openActivityFromURI(@NonNull FileBasedActivity v, @NonNull URI uri, @NonNull URIChooser chooser, WorkState<Void> workState) {
        Application app = this.getApplication();
        Map<Key<?>, Object> options = this.getReadOptions();
        app.removeDisabler(workState);
        v.addDisabler(workState);
        DataFormat chosenFormat = chooser.getDataFormat();
        v.setDataFormat(chosenFormat);
        v.read(uri, chosenFormat, (ImmutableMap<Key<?>, Object>)ChampMap.copyOf(options), false, workState).whenComplete((actualFormat, exception) -> {
            if (exception instanceof CancellationException) {
                v.removeDisabler(workState);
            } else if (exception != null) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Unexpected Exception " + exception.getMessage(), (Throwable)exception);
                Resources labels = ApplicationLabels.getResources();
                TextArea textArea = new TextArea(this.createErrorMessage((Throwable)exception));
                textArea.setEditable(false);
                textArea.setWrapText(true);
                Alert alert = new Alert(Alert.AlertType.ERROR);
                alert.getDialogPane().setMaxWidth(640.0);
                alert.setHeaderText(labels.getFormatted("file.open.couldntOpen.message", UriUtil.getName((URI)uri)));
                alert.getDialogPane().setContent((Node)textArea);
                alert.showAndWait();
                v.removeDisabler(workState);
            } else {
                v.setURI(uri);
                v.setDataFormat((DataFormat)actualFormat);
                v.clearModified();
                this.getApplication().getRecentUris().put((Object)uri, actualFormat);
                v.removeDisabler(workState);
            }
        });
    }

    protected abstract @NonNull Map<Key<?>, Object> getReadOptions();

    private /* synthetic */ void lambda$onActionPerformed$0(WorkState workState, Activity v) {
        this.doIt((FileBasedActivity)v, true, (WorkState<Void>)workState);
    }
}

