/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.application.action.file;

import java.lang.reflect.Type;
import java.net.URI;
import java.util.SequencedMap;
import java.util.function.Function;
import java.util.function.Supplier;
import javafx.scene.control.Dialog;
import javafx.scene.input.DataFormat;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.application.FileBasedActivity;
import org.jhotdraw8.application.action.file.AbstractSaveFileAction;
import org.jhotdraw8.application.controls.urichooser.FileURIChooser;
import org.jhotdraw8.application.controls.urichooser.URIChooser;
import org.jhotdraw8.fxcollection.typesafekey.Key;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jhotdraw8.fxcollection.typesafekey.NullableObjectKey;
import org.jhotdraw8.fxcollection.typesafekey.SimpleParameterizedType;

public class ExportFileAction
extends AbstractSaveFileAction {
    public static final String ID = "file.export";
    private final Function<DataFormat, Dialog<SequencedMap<Key<?>, Object>>> optionsDialogFactory;
    public static final @NonNull Key<URIChooser> EXPORT_CHOOSER_KEY = new NullableObjectKey("exportChooser", URIChooser.class);
    public static final @NonNull Key<Supplier<URIChooser>> EXPORT_CHOOSER_FACTORY_KEY = new NullableObjectKey("exportChooserFactory", (Type)new SimpleParameterizedType(Supplier.class, new Type[]{URIChooser.class}));

    public ExportFileAction(@NonNull FileBasedActivity activity) {
        this(activity, ID, null);
    }

    public ExportFileAction(@NonNull FileBasedActivity activity, Function<DataFormat, Dialog<SequencedMap<Key<?>, Object>>> optionsDialog) {
        this(activity, ID, optionsDialog);
    }

    public ExportFileAction(@NonNull FileBasedActivity activity, String id, Function<DataFormat, Dialog<SequencedMap<Key<?>, Object>>> optionsDialog) {
        super(activity, id, true);
        this.optionsDialogFactory = optionsDialog;
    }

    @Override
    protected @NonNull URIChooser getChooser(FileBasedActivity view) {
        URIChooser chooser = (URIChooser)this.app.get((MapAccessor)EXPORT_CHOOSER_KEY);
        if (chooser == null) {
            Supplier factory = (Supplier)this.app.get((MapAccessor)EXPORT_CHOOSER_FACTORY_KEY);
            chooser = factory == null ? new FileURIChooser(FileURIChooser.Mode.SAVE) : (URIChooser)factory.get();
            this.app.set((MapAccessor)EXPORT_CHOOSER_KEY, chooser);
        }
        return chooser;
    }

    @Override
    protected @Nullable Dialog<SequencedMap<Key<?>, Object>> createOptionsDialog(DataFormat format) {
        return this.optionsDialogFactory == null ? null : this.optionsDialogFactory.apply(format);
    }

    @Override
    protected void onSaveSucceeded(FileBasedActivity v, URI uri, DataFormat format) {
    }
}

