/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.application.action.file;

import javafx.event.ActionEvent;
import javafx.print.PrinterJob;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.application.ApplicationLabels;
import org.jhotdraw8.application.FileBasedActivity;
import org.jhotdraw8.application.action.AbstractActivityAction;
import org.jhotdraw8.fxbase.concurrent.SimpleWorkState;
import org.jhotdraw8.fxbase.concurrent.WorkState;

public class PrintFileAction
extends AbstractActivityAction<FileBasedActivity> {
    public static final String ID = "file.print";

    public PrintFileAction(@NonNull FileBasedActivity activity) {
        super(activity);
        ApplicationLabels.getResources().configureAction(this, ID);
    }

    @Override
    protected void onActionPerformed(@NonNull ActionEvent event, @NonNull FileBasedActivity activity) {
        SimpleWorkState workState = new SimpleWorkState();
        activity.addDisabler(workState);
        PrinterJob job = PrinterJob.createPrinterJob();
        if (job != null && job.showPrintDialog(activity.getNode().getScene().getWindow())) {
            activity.print(job, (WorkState<Void>)workState).thenRun(() -> PrintFileAction.lambda$onActionPerformed$0(activity, (WorkState)workState));
        } else {
            Alert alert = new Alert(Alert.AlertType.INFORMATION, "Sorry, no printer found", new ButtonType[0]);
            alert.getDialogPane().setMaxWidth(640.0);
            alert.show();
            activity.removeDisabler(workState);
        }
    }

    private static /* synthetic */ void lambda$onActionPerformed$0(FileBasedActivity activity, WorkState workState) {
        activity.removeDisabler(workState);
    }
}

