/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.application.controls.urichooser;

import java.io.File;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.input.DataFormat;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.application.controls.urichooser.URIChooser;
import org.jhotdraw8.application.controls.urichooser.URIExtensionFilter;

public class FileURIChooser
implements URIChooser {
    private final FileChooser chooser = new FileChooser();
    private final ObservableList<URIExtensionFilter> filters = FXCollections.observableArrayList();
    private Mode mode;

    private void updateFilters() {
        ObservableList cfilters = this.chooser.getExtensionFilters();
        cfilters.clear();
        for (URIExtensionFilter f : this.filters) {
            cfilters.add((Object)f.getFileChooserExtensionFilter());
        }
    }

    public FileURIChooser() {
        this(Mode.OPEN);
    }

    public FileURIChooser(@NonNull Mode newValue) {
        this(newValue, Collections.emptyList());
    }

    public FileURIChooser(@NonNull Mode newValue, @NonNull List<URIExtensionFilter> extensionFilters) {
        this.mode = newValue;
        this.filters.setAll(extensionFilters);
    }

    public void setMode(Mode newValue) {
        this.mode = newValue;
    }

    public Mode getMode() {
        return this.mode;
    }

    public @NonNull FileChooser getFileChooser() {
        return this.chooser;
    }

    @Override
    public @Nullable URI showDialog(Window parent) {
        this.updateFilters();
        File f = switch (this.mode.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> this.chooser.showOpenDialog(parent);
            case 1 -> this.chooser.showSaveDialog(parent);
        };
        return f == null ? null : f.toURI();
    }

    public void setExtensionFilters(List<URIExtensionFilter> filters) {
        this.filters.setAll(filters);
    }

    @Override
    public @Nullable DataFormat getDataFormat() {
        for (URIExtensionFilter f : this.filters) {
            if (f.getFileChooserExtensionFilter() != this.chooser.getSelectedExtensionFilter()) continue;
            return f.getDataFormat();
        }
        return null;
    }

    public static enum Mode {
        OPEN,
        SAVE;

    }
}

