/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.application.prefs;

import java.util.concurrent.ConcurrentHashMap;
import java.util.prefs.Preferences;
import javafx.beans.property.BooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.collections.ObservableList;
import javafx.geometry.Dimension2D;
import javafx.geometry.Rectangle2D;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.control.SplitPane;
import javafx.stage.Screen;
import javafx.stage.Stage;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.application.prefs.PreferencesStub;

public class PreferencesUtil {
    private static final ConcurrentHashMap<Package, Preferences> systemNodes = new ConcurrentHashMap();
    private static final ConcurrentHashMap<Package, Preferences> userNodes = new ConcurrentHashMap();

    public static Preferences systemNodeForPackage(@NonNull Class<?> c) {
        return systemNodes.computeIfAbsent(c.getPackage(), pckg -> {
            try {
                return Preferences.systemNodeForPackage(c);
            }
            catch (Throwable t) {
                return new PreferencesStub(false);
            }
        });
    }

    public static Preferences userNodeForPackage(@NonNull Class<?> c) {
        return userNodes.computeIfAbsent(c.getPackage(), pckg -> {
            try {
                return Preferences.userNodeForPackage(c);
            }
            catch (Throwable t) {
                return new PreferencesStub(true);
            }
        });
    }

    private PreferencesUtil() {
    }

    public static void installStagePrefsHandler(@NonNull Preferences prefs, String name, @NonNull Stage stage) {
        PreferencesUtil.installStagePrefsHandler(prefs, name, stage, new Dimension2D(400.0, 300.0));
    }

    public static void installStagePrefsHandler(@NonNull Preferences prefs, String name, @NonNull Stage stage, @NonNull Dimension2D defaultSize) {
        double prefWidth = prefs.getDouble(name + ".width", defaultSize.getWidth());
        double prefHeight = prefs.getDouble(name + ".height", defaultSize.getHeight());
        Rectangle2D stageBounds = new Rectangle2D(0.0, 0.0, prefWidth, prefHeight);
        Screen primary = Screen.getPrimary();
        Rectangle2D screenBounds = primary == null ? stageBounds : primary.getVisualBounds();
        stage.setWidth(Math.min(screenBounds.getWidth(), prefWidth));
        stage.setHeight(Math.min(screenBounds.getHeight(), prefHeight));
        stage.widthProperty().addListener((o, oldValue, newValue) -> prefs.putDouble(name + ".width", newValue.doubleValue()));
        stage.heightProperty().addListener((o, oldValue, newValue) -> prefs.putDouble(name + ".height", newValue.doubleValue()));
    }

    public static void installVisibilityPrefsHandlers(@NonNull Preferences prefs, @NonNull Node node, @NonNull BooleanProperty visibilityProperty, @NonNull SplitPane splitPane, Side side) {
        ChangeListener positionListener = (o, oldValue, newValue) -> prefs.putDouble(visibilityProperty.getName() + ".dividerPosition", newValue.doubleValue());
        ChangeListener visibilityListener = (o, oldValue, newValue) -> {
            block9: {
                boolean first;
                node.setVisible(newValue.booleanValue());
                ObservableList dividers = splitPane.getDividers();
                double[] oldPositions = new double[dividers.size()];
                for (int i = 0; i < oldPositions.length; ++i) {
                    oldPositions[i] = ((SplitPane.Divider)dividers.get(i)).getPosition();
                }
                boolean bl = first = side == Side.LEFT || side == Side.TOP;
                if (newValue.booleanValue()) {
                    if (first) {
                        splitPane.getItems().addFirst((Object)node);
                    } else {
                        splitPane.getItems().add((Object)node);
                    }
                    SplitPane.setResizableWithParent((Node)node, (Boolean)false);
                    pp = ((SplitPane.Divider)dividers.get(first ? 0 : dividers.size() - 1)).positionProperty();
                    pp.set(prefs.getDouble(visibilityProperty.getName() + ".dividerPosition", first ? 0.2 : 0.8));
                    pp.addListener(positionListener);
                } else {
                    pp = ((SplitPane.Divider)dividers.get(first ? 0 : dividers.size() - 1)).positionProperty();
                    pp.removeListener(positionListener);
                    splitPane.getItems().remove((Object)node);
                }
                prefs.putBoolean(visibilityProperty.getName(), (boolean)newValue);
                if (!first) break block9;
                if (newValue.booleanValue()) {
                    for (int i = 0; i < oldPositions.length; ++i) {
                        ((SplitPane.Divider)dividers.get(i + 1)).setPosition(oldPositions[i]);
                    }
                } else {
                    for (int i = 1; i < oldPositions.length; ++i) {
                        ((SplitPane.Divider)dividers.get(i - 1)).setPosition(oldPositions[i]);
                    }
                }
            }
        };
        splitPane.getItems().remove((Object)node);
        visibilityProperty.set(false);
        visibilityProperty.addListener(visibilityListener);
        visibilityProperty.set(prefs.getBoolean(visibilityProperty.getName(), true));
    }

    public static void installBooleanPropertyHandler(@NonNull Preferences prefs, String name, @NonNull BooleanProperty property) {
        boolean prefValue = prefs.getBoolean(name, true);
        property.setValue(Boolean.valueOf(prefValue));
        property.addListener((o, oldValue, newValue) -> prefs.putBoolean(name, (boolean)newValue));
    }
}

