/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.application.prefs;

import java.util.prefs.Preferences;
import org.jhotdraw8.annotation.NonNull;

public class PrefsIntKey {
    private final String key;
    private final int defaultValue;
    private final int clampMin;
    private final int clampMax;

    public PrefsIntKey(String key, int defaultValue, int clampMin, int clampMax) {
        this.key = key;
        this.defaultValue = defaultValue;
        this.clampMin = clampMin;
        this.clampMax = clampMax;
    }

    public int get(@NonNull Preferences prefs) {
        return this.clamp(prefs.getInt(this.key, this.defaultValue), this.clampMin, this.clampMax);
    }

    public void put(@NonNull Preferences prefs, int newValue) {
        prefs.putInt(this.key, newValue);
    }

    private int clamp(int value, int min, int max) {
        return min <= value ? Math.min(value, max) : min;
    }
}

