/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.application.resources;

import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Pattern;
import javafx.scene.Node;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.application.resources.ResourceDecoder;

public class FontIconDecoder
implements ResourceDecoder {
    private final @NonNull Pattern keyPattern;
    private final String valuePrefix;
    private final Font font;

    public FontIconDecoder(@NonNull String keyRegex, Font font) {
        this(keyRegex, "fonticon:", font);
    }

    public FontIconDecoder(@NonNull String keyRegex, String valuePrefix, Font font) {
        this.keyPattern = Pattern.compile(keyRegex);
        this.valuePrefix = valuePrefix;
        this.font = font;
    }

    public FontIconDecoder(@NonNull String keyRegex, String valuePrefix, @NonNull String fontResourceName, float fontSize, @NonNull Class<?> baseClass) throws IOException {
        this.keyPattern = Pattern.compile(keyRegex);
        this.valuePrefix = valuePrefix;
        try (InputStream in = baseClass.getResourceAsStream(fontResourceName);){
            this.font = Font.loadFont((InputStream)in, (double)fontSize);
        }
    }

    @Override
    public boolean canDecodeValue(@NonNull String key, @NonNull String propertyValue, @NonNull Class<?> type) {
        return this.keyPattern.matcher(key).matches() && propertyValue.startsWith(this.valuePrefix) && Node.class.isAssignableFrom(type);
    }

    @Override
    public <T> @NonNull T decode(String key, @NonNull String propertyValue, Class<T> type, Class<?> baseClass) {
        Text txt = new Text();
        txt.setFont(this.font);
        txt.setText(this.decodeValue(key, propertyValue));
        return type.cast(txt);
    }

    private @NonNull String decodeValue(String key, @NonNull String propertyValue) {
        String str = propertyValue.substring(this.valuePrefix.length()).trim();
        if (!str.startsWith("U+")) {
            throw new InternalError("illegal property value \"" + propertyValue + "\" for key " + key);
        }
        int codePoint = Integer.valueOf(str.substring(2).trim(), 16);
        return new String(Character.toChars(codePoint));
    }
}

