/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.application.resources;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.ServiceLoader;
import java.util.logging.Logger;
import java.util.spi.ResourceBundleProvider;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.application.resources.LocaleUtil;
import org.jhotdraw8.application.resources.Resources;

public class ModulepathResources
extends ResourceBundle
implements Serializable,
Resources {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(ModulepathResources.class.getName());
    private Class<?> baseClass = this.getClass();
    private final @NonNull String baseName;
    private final @NonNull Locale locale;
    private @Nullable Resources parent;
    private final transient ResourceBundle resource;
    private final Module module;

    public static @NonNull ModulepathResources getResources(@NonNull String moduleName, @NonNull String baseName) throws MissingResourceException {
        return ModulepathResources.getResources(moduleName, baseName, LocaleUtil.getDefault());
    }

    public static @NonNull Resources getResources(@NonNull Module module, @NonNull String baseName) throws MissingResourceException {
        return ModulepathResources.getResources(module, baseName, LocaleUtil.getDefault());
    }

    static ModulepathResources getResources(@NonNull String moduleName, @NonNull String baseName, @NonNull Locale locale) throws MissingResourceException {
        ModulepathResources r = new ModulepathResources(ModuleLayer.boot().findModule(moduleName).orElseThrow(() -> new MissingResourceException("Could not find a module with moduleName=\"" + moduleName + "\".", baseName, locale.toString())), baseName, locale);
        return r;
    }

    public static ModulepathResources getResources(@NonNull Module module, @NonNull String baseName, @NonNull Locale locale) throws MissingResourceException {
        ModulepathResources r = new ModulepathResources(module, baseName, locale);
        return r;
    }

    public ModulepathResources(@NonNull Module module, @NonNull String baseName, @NonNull Locale locale) throws MissingResourceException {
        this.locale = locale;
        this.baseName = baseName;
        this.resource = ModulepathResources.doGetBundle(module, baseName, locale);
        this.module = module;
        ModulepathResources potentialParent = null;
        String moduleAndParentBaseName = null;
        try {
            moduleAndParentBaseName = this.resource.getString("$parent");
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        if (moduleAndParentBaseName != null) {
            Module parentModule;
            String[] split = moduleAndParentBaseName.split("\\s+|\\s*,\\s*");
            String parentBaseName = switch (split.length) {
                case 1 -> {
                    parentModule = module;
                    yield split[0];
                }
                case 2 -> {
                    parentModule = ModuleLayer.boot().findModule(split[0]).orElseThrow(() -> new MissingResourceException("Could not find a module with moduleName=\"" + split[0] + "\".", baseName, locale.toString()));
                    yield split[1];
                }
                default -> throw new IllegalArgumentException("Could not parse the value of the property $parent=\"" + moduleAndParentBaseName + "\".");
            };
            try {
                potentialParent = new ModulepathResources(parentModule, parentBaseName, locale);
            }
            catch (MissingResourceException e) {
                MissingResourceException ex = new MissingResourceException("Could not find the resource bundle in module=\"" + String.valueOf(module) + "\".", baseName, locale.toString());
                ex.initCause(e);
                throw ex;
            }
        }
        this.parent = potentialParent;
    }

    private static ResourceBundle doGetBundle(Module module, String baseName, @NonNull Locale locale) {
        for (ResourceBundleProvider provider : ServiceLoader.load(ResourceBundleProvider.class)) {
            ResourceBundle bundle;
            if (!provider.getClass().getModule().equals(module) || (bundle = provider.getBundle(baseName, locale)) == null) continue;
            return bundle;
        }
        throw new MissingResourceException("Could not find the resource bundle.", baseName, locale.toString());
    }

    @Override
    public @NonNull ResourceBundle asResourceBundle() {
        return this;
    }

    @Override
    public boolean containsKey(@Nullable String key) {
        Objects.requireNonNull(key, "key");
        if (this.resource.containsKey(key)) {
            return true;
        }
        if (this.parent != null) {
            return this.parent.containsKey(key);
        }
        LOG.warning("Could not find a resource with key=\"" + key + "\" in resource bundle=\"" + this.baseName + "\".");
        return false;
    }

    @Override
    public Class<?> getBaseClass() {
        return this.baseClass;
    }

    @Override
    public @NonNull String getBaseName() {
        return this.baseName;
    }

    public void setBaseClass(Class<?> baseClass) {
        this.baseClass = baseClass;
    }

    @Override
    public @NonNull String getFormatted(@NonNull String key, Object ... arguments) {
        return MessageFormat.format(this.getString(key), arguments);
    }

    @Override
    protected @Nullable Object handleGetObject(@NonNull String key) {
        Object obj = this.handleGetObjectRecursively(key);
        if (obj == null) {
            obj = "";
            LOG.warning("Can't find resource for bundle " + this.baseName + ", key " + key);
        }
        if (obj instanceof String) {
            obj = this.substitutePlaceholders(key, (String)obj);
        }
        return obj;
    }

    @Override
    public @Nullable Object handleGetObjectRecursively(@NonNull String key) {
        Object obj;
        block2: {
            obj = null;
            try {
                obj = this.resource.getObject(key);
            }
            catch (MissingResourceException e) {
                if (this.parent == null) break block2;
                return this.parent.handleGetObjectRecursively(key);
            }
        }
        return obj;
    }

    public @NonNull String toString() {
        return "ModulepathResources[" + this.baseName + "]";
    }

    @Override
    public Module getModule() {
        return this.module;
    }

    @Override
    public @NonNull Enumeration<String> getKeys() {
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        for (String key : () -> this.resource.getKeys().asIterator()) {
            keys.add(key);
        }
        if (this.parent != null) {
            for (String key : () -> this.parent.getKeys().asIterator()) {
                keys.add(key);
            }
        }
        return Collections.enumeration(keys);
    }

    @Override
    public @Nullable Resources getParent() {
        return this.parent;
    }

    @Override
    public @NonNull Locale getLocale() {
        return super.getLocale();
    }

    @Override
    public void setParent(@Nullable Resources parent) {
        this.parent = parent;
    }
}

