/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.application;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javafx.beans.binding.Bindings;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyListProperty;
import javafx.beans.property.ReadOnlyListWrapper;
import javafx.beans.property.ReadOnlyMapProperty;
import javafx.beans.property.ReadOnlyMapWrapper;
import javafx.beans.property.ReadOnlySetProperty;
import javafx.beans.property.ReadOnlySetWrapper;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableMap;
import javafx.collections.ObservableSet;
import javafx.scene.control.MenuBar;
import javafx.scene.input.DataFormat;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.application.Activity;
import org.jhotdraw8.application.Application;
import org.jhotdraw8.application.action.Action;
import org.jhotdraw8.application.resources.EmptyResources;
import org.jhotdraw8.application.resources.Resources;
import org.jhotdraw8.fxbase.beans.NonNullObjectProperty;
import org.jhotdraw8.fxcollection.typesafekey.Key;

public abstract class AbstractApplication
extends javafx.application.Application
implements Application {
    private static final @NonNull String RECENT_URIS = ".recentUriFormats";
    private final @NonNull ReadOnlyBooleanProperty disabled;
    private final @NonNull ObservableSet<Object> disablers = FXCollections.observableSet((Object[])new Object[0]);
    private final @NonNull ReadOnlyMapProperty<String, Action> actions = new ReadOnlyMapWrapper((Object)this, "actions", FXCollections.observableMap(new LinkedHashMap())).getReadOnlyProperty();
    private final @NonNull ReadOnlySetProperty<Activity> activities = new ReadOnlySetWrapper((Object)this, "activities", FXCollections.observableSet(new LinkedHashSet())).getReadOnlyProperty();
    private final @NonNull ReadOnlyListProperty<String> stylesheets = new ReadOnlyListWrapper((Object)this, "stylesheets", FXCollections.observableArrayList()).getReadOnlyProperty();
    private final @NonNull ObjectProperty<Supplier<Activity>> activityFactory = new SimpleObjectProperty((Object)this, "activityFactory");
    private final @NonNull ObjectProperty<Supplier<MenuBar>> menuFactory = new SimpleObjectProperty((Object)this, "menuBarFactory");
    private final @NonNull NonNullObjectProperty<Resources> resources = new NonNullObjectProperty((Object)this, "resourceBundle", (Object)new EmptyResources());
    private final @NonNull NonNullObjectProperty<Preferences> preferences = new NonNullObjectProperty((Object)this, "preferences", (Object)Preferences.userNodeForPackage(this.getClass()));
    private final IntegerProperty maxNumberOfRecentUris = new SimpleIntegerProperty((Object)this, "maxNumberOfRecentUris", 10);
    private ObservableMap<Key<?>, Object> properties;
    private final ReadOnlyMapProperty<URI, DataFormat> recentUris = new ReadOnlyMapWrapper((Object)this, "recentUris", FXCollections.observableMap(new LinkedHashMap(16, 0.5f, true))).getReadOnlyProperty();

    public AbstractApplication() {
        ReadOnlyBooleanWrapper robw = new ReadOnlyBooleanWrapper((Object)this, "disabled");
        robw.bind((ObservableValue)Bindings.isNotEmpty(this.disablers));
        this.disabled = robw.getReadOnlyProperty();
    }

    public ReadOnlyBooleanProperty disabledProperty() {
        return this.disabled;
    }

    public @NonNull ObservableSet<Object> disablers() {
        return this.disablers;
    }

    public final @NonNull ObservableMap<Key<?>, Object> getProperties() {
        if (this.properties == null) {
            this.properties = FXCollections.observableHashMap();
        }
        return this.properties;
    }

    protected void loadRecentUris(String applicationId) {
        Preferences prefs = this.getPreferences();
        String recentUrisSerialized = prefs.get(applicationId + RECENT_URIS, "");
        for (String row : recentUrisSerialized.split("\n")) {
            if (row.isEmpty()) continue;
            if (this.recentUris.size() >= this.getMaxNumberOfRecentUris()) break;
            String[] columns = row.split("\t");
            if (columns.length < 1) continue;
            try {
                URI uri = new URI(columns[0]);
                DataFormat format = null;
                if (columns.length > 1 && !columns[1].isEmpty() && (format = DataFormat.lookupMimeType((String)columns[1])) == null) {
                    format = new DataFormat(new String[]{columns[1]});
                }
                this.recentUris.put((Object)uri, format);
            }
            catch (URISyntaxException ex) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Unexpected Exception " + ex.getMessage(), ex);
            }
        }
        ((ObservableMap)this.recentUris.get()).addListener(change -> {
            StringBuilder buf = new StringBuilder();
            int skip = this.recentUris.size() - this.getMaxNumberOfRecentUris();
            for (Map.Entry entry : this.recentUris.entrySet()) {
                if (skip-- > 0) continue;
                if (!buf.isEmpty()) {
                    buf.append('\n');
                }
                URI uri = (URI)entry.getKey();
                DataFormat format = (DataFormat)entry.getValue();
                if (uri == null) continue;
                buf.append(uri);
                if (format == null || format.getIdentifiers() == null || format.getIdentifiers().isEmpty()) continue;
                buf.append('\t').append((String)format.getIdentifiers().iterator().next());
            }
            prefs.put(applicationId + RECENT_URIS, buf.toString());
        });
    }

    @Override
    public @NonNull IntegerProperty maxNumberOfRecentUrisProperty() {
        return this.maxNumberOfRecentUris;
    }

    @Override
    public ReadOnlyMapProperty<URI, DataFormat> recentUrisProperty() {
        return this.recentUris;
    }

    @Override
    public @NonNull ReadOnlyMapProperty<String, Action> actionsProperty() {
        return this.actions;
    }

    @Override
    public @NonNull ReadOnlySetProperty<Activity> activitiesProperty() {
        return this.activities;
    }

    @Override
    public @NonNull ReadOnlyListProperty<String> stylesheetsProperty() {
        return this.stylesheets;
    }

    @Override
    public @NonNull ObjectProperty<Supplier<Activity>> activityFactoryProperty() {
        return this.activityFactory;
    }

    @Override
    public @NonNull ObjectProperty<Supplier<MenuBar>> menuBarFactoryProperty() {
        return this.menuFactory;
    }

    @Override
    public @NonNull NonNullObjectProperty<Resources> resourcesProperty() {
        return this.resources;
    }

    @Override
    public @NonNull NonNullObjectProperty<Preferences> preferencesProperty() {
        return this.preferences;
    }

    @Override
    public Executor getExecutor() {
        return ForkJoinPool.commonPool();
    }
}

