/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.application.action;

import java.util.Objects;
import java.util.concurrent.ExecutionException;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableSet;
import javafx.event.ActionEvent;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.TextArea;
import javafx.scene.layout.GridPane;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.application.Application;
import org.jhotdraw8.application.action.AbstractAction;

public abstract class AbstractApplicationAction
extends AbstractAction {
    protected final @NonNull Application app;

    public AbstractApplicationAction(@NonNull Application app) {
        Objects.requireNonNull(app, "app");
        this.app = app;
        this.disabled.unbind();
        this.disabled.bind((ObservableValue)Bindings.isNotEmpty((ObservableSet)this.disablers).or((ObservableBooleanValue)app.disabledProperty()));
    }

    protected @NonNull String createErrorMessage(@Nullable Throwable t) {
        StringBuilder buf = new StringBuilder();
        while (t != null) {
            String msg;
            if ((t.getCause() == null || !(t instanceof RuntimeException) && !(t instanceof ExecutionException)) && buf.indexOf(msg = t.getLocalizedMessage()) < 0) {
                if (!buf.isEmpty()) {
                    buf.append('\n');
                }
                buf.append((String)(msg == null ? t.toString() : t.getClass().getSimpleName() + ": " + msg));
            }
            t = t.getCause();
        }
        return buf.toString();
    }

    public final @NonNull Application getApplication() {
        return this.app;
    }

    @Override
    protected final void onActionPerformed(@NonNull ActionEvent event) {
        this.onActionPerformed(event, this.app);
    }

    protected abstract void onActionPerformed(@NonNull ActionEvent var1, @NonNull Application var2);

    protected @NonNull Alert createAlert(Alert.AlertType alertType, String message, String headerText) {
        TextArea textArea = new TextArea(message);
        textArea.setEditable(false);
        textArea.setWrapText(true);
        GridPane gridPane = new GridPane();
        gridPane.add((Node)textArea, 0, 0);
        Alert alert = new Alert(alertType);
        alert.getDialogPane().setContent((Node)gridPane);
        alert.setHeaderText(headerText);
        alert.getDialogPane().setMaxWidth(640.0);
        return alert;
    }
}

