/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.application.action;

import java.net.URI;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.event.ActionEvent;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.DialogEvent;
import javafx.scene.input.DataFormat;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.application.Activity;
import org.jhotdraw8.application.ApplicationLabels;
import org.jhotdraw8.application.FileBasedActivity;
import org.jhotdraw8.application.FileBasedApplication;
import org.jhotdraw8.application.action.AbstractActivityAction;
import org.jhotdraw8.application.action.file.AbstractSaveFileAction;
import org.jhotdraw8.application.controls.urichooser.FileURIChooser;
import org.jhotdraw8.application.controls.urichooser.URIChooser;
import org.jhotdraw8.application.resources.Resources;
import org.jhotdraw8.base.net.UriUtil;
import org.jhotdraw8.fxbase.concurrent.SimpleWorkState;
import org.jhotdraw8.fxbase.concurrent.WorkState;
import org.jhotdraw8.fxcollection.typesafekey.Key;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jhotdraw8.fxcollection.typesafekey.NonNullMapAccessor;
import org.jhotdraw8.icollection.ChampMap;
import org.jhotdraw8.icollection.immutable.ImmutableMap;

public abstract class AbstractSaveUnsavedChangesAction
extends AbstractActivityAction<FileBasedActivity> {
    private final Logger LOGGER = Logger.getLogger(AbstractSaveUnsavedChangesAction.class.getName());
    private @Nullable Node oldFocusOwner = null;

    public AbstractSaveUnsavedChangesAction(@NonNull FileBasedActivity activity) {
        super(activity);
    }

    @Override
    protected final void onActionPerformed(@NonNull ActionEvent evt, @NonNull FileBasedActivity activity) {
        this.onActionOnViewPerformed(activity);
    }

    protected @Nullable URIChooser getChooser(FileBasedActivity view) {
        URIChooser chooser = (URIChooser)this.app.get((MapAccessor)AbstractSaveFileAction.SAVE_CHOOSER_KEY);
        if (chooser == null) {
            Supplier factory = (Supplier)this.app.get((MapAccessor)AbstractSaveFileAction.SAVE_CHOOSER_FACTORY_KEY);
            chooser = factory == null ? new FileURIChooser(FileURIChooser.Mode.SAVE) : (URIChooser)factory.get();
            this.app.set((MapAccessor)AbstractSaveFileAction.SAVE_CHOOSER_KEY, chooser);
        }
        return chooser;
    }

    public void onActionOnViewPerformed(@NonNull FileBasedActivity v) {
        if (!v.isDisabled()) {
            Resources labels = ApplicationLabels.getResources();
            this.oldFocusOwner = this.getFocusOwner(v.getNode());
            SimpleWorkState workState = new SimpleWorkState(this.getLabel());
            v.addDisabler(workState);
            if (v.isModified()) {
                URI unsavedURI = v.getURI();
                ButtonType[] options = new ButtonType[]{new ButtonType(labels.getString("file.saveBefore.saveOption.text"), ButtonBar.ButtonData.YES), new ButtonType(labels.getString("file.saveBefore.cancelOption.text"), ButtonBar.ButtonData.CANCEL_CLOSE), new ButtonType(labels.getString("file.saveBefore.dontSaveOption.text"), ButtonBar.ButtonData.NO)};
                Alert alert = new Alert(Alert.AlertType.CONFIRMATION, labels.getString("file.saveBefore.doYouWantToSave.details"), options);
                alert.getDialogPane().setMaxWidth(640.0);
                alert.setHeaderText(labels.getFormatted("file.saveBefore.doYouWantToSave.message", v.getTitle(), v.getDisambiguation()));
                alert.setOnHidden(arg_0 -> this.lambda$onActionOnViewPerformed$1(alert, v, (WorkState)workState, arg_0));
                Window w = v.getNode().getScene().getWindow();
                if (w instanceof Stage) {
                    ((Stage)w).toFront();
                }
                alert.initOwner(w);
                alert.initModality(Modality.WINDOW_MODAL);
                alert.show();
            } else {
                this.doIt(v).whenComplete((arg_0, arg_1) -> this.lambda$onActionOnViewPerformed$2(v, (WorkState)workState, arg_0, arg_1));
            }
        }
    }

    protected @Nullable Node getFocusOwner(@NonNull Node node) {
        Scene scene = node.getScene();
        return scene == null ? null : scene.getFocusOwner();
    }

    protected void saveView(@NonNull FileBasedActivity v, WorkState<Void> workState) {
        if (v.getURI() == null) {
            URIChooser chooser = this.getChooser(v);
            URI uri = null;
            block0: while ((uri = chooser.showDialog(v.getNode())) != null && !((Boolean)this.app.getNonNull((NonNullMapAccessor)FileBasedApplication.ALLOW_MULTIPLE_ACTIVITIES_WITH_SAME_URI)).booleanValue()) {
                for (Activity vi : this.app.getActivities()) {
                    if (vi == v || !v.getURI().equals(uri)) continue;
                    Alert alert = new Alert(Alert.AlertType.INFORMATION, "You can not save to a file which is already open.", new ButtonType[0]);
                    alert.getDialogPane().setMaxWidth(640.0);
                    alert.showAndWait();
                    continue block0;
                }
            }
            if (uri != null) {
                this.saveViewToURI(v, uri, chooser, chooser.getDataFormat(), workState);
            }
            v.removeDisabler(workState);
            if (this.oldFocusOwner != null) {
                this.oldFocusOwner.requestFocus();
            }
        } else {
            this.saveViewToURI(v, v.getURI(), null, v.getDataFormat(), workState);
        }
    }

    protected void saveViewToURI(@NonNull FileBasedActivity v, @NonNull URI uri, @Nullable URIChooser chooser, DataFormat dataFormat, WorkState<Void> workState) {
        v.write(uri, dataFormat, (ImmutableMap<Key<?>, Object>)ChampMap.of(), workState).handle((? super T result, Throwable exception) -> {
            if (exception instanceof CancellationException) {
                v.removeDisabler(workState);
                if (this.oldFocusOwner != null) {
                    this.oldFocusOwner.requestFocus();
                }
            } else if (exception != null) {
                this.LOGGER.log(Level.WARNING, (Throwable)exception, () -> "Couldn't save file: " + String.valueOf(uri));
                Resources labels = ApplicationLabels.getResources();
                Alert alert = new Alert(Alert.AlertType.ERROR, this.createErrorMessage((Throwable)exception), new ButtonType[0]);
                alert.getDialogPane().setMaxWidth(640.0);
                alert.setHeaderText(labels.getFormatted("file.save.couldntSave.message", UriUtil.getName((URI)uri)));
                alert.showAndWait();
                v.removeDisabler(workState);
                if (this.oldFocusOwner != null) {
                    this.oldFocusOwner.requestFocus();
                }
            } else {
                v.setURI(uri);
                v.clearModified();
                this.app.getRecentUris().put((Object)uri, (Object)dataFormat);
                this.doIt(v);
            }
            return null;
        });
    }

    protected abstract CompletionStage<Void> doIt(FileBasedActivity var1);

    private /* synthetic */ void lambda$onActionOnViewPerformed$2(FileBasedActivity v, WorkState workState, Void result, Throwable exception) {
        v.removeDisabler(workState);
        if (this.oldFocusOwner != null) {
            this.oldFocusOwner.requestFocus();
        }
    }

    private /* synthetic */ void lambda$onActionOnViewPerformed$1(Alert alert, FileBasedActivity v, WorkState workState, DialogEvent dialogEvent) {
        ButtonType result = (ButtonType)alert.getResult();
        if (result != null) {
            switch (result.getButtonData()) {
                default: {
                    v.removeDisabler(workState);
                    if (this.oldFocusOwner == null) break;
                    this.oldFocusOwner.requestFocus();
                    break;
                }
                case NO: {
                    this.doIt(v).whenComplete((r, e) -> {
                        v.removeDisabler(workState);
                        if (this.oldFocusOwner != null) {
                            this.oldFocusOwner.requestFocus();
                        }
                    });
                    break;
                }
                case YES: {
                    this.saveView(v, (WorkState<Void>)workState);
                }
            }
        }
    }
}

