/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.application.action.app;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.function.Supplier;
import javafx.event.ActionEvent;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.input.DataFormat;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.application.Activity;
import org.jhotdraw8.application.Application;
import org.jhotdraw8.application.ApplicationLabels;
import org.jhotdraw8.application.FileBasedActivity;
import org.jhotdraw8.application.action.AbstractApplicationAction;
import org.jhotdraw8.application.action.file.AbstractSaveFileAction;
import org.jhotdraw8.application.controls.urichooser.FileURIChooser;
import org.jhotdraw8.application.controls.urichooser.URIChooser;
import org.jhotdraw8.application.resources.Resources;
import org.jhotdraw8.base.net.UriUtil;
import org.jhotdraw8.fxbase.concurrent.SimpleWorkState;
import org.jhotdraw8.fxbase.concurrent.WorkState;
import org.jhotdraw8.fxcollection.typesafekey.Key;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jhotdraw8.icollection.ChampMap;
import org.jhotdraw8.icollection.immutable.ImmutableMap;

public class ExitAction
extends AbstractApplicationAction {
    public static final String ID = "application.exit";
    private Node oldFocusOwner;
    private @Nullable FileBasedActivity unsavedView;

    public ExitAction(Application app) {
        super(app);
        ApplicationLabels.getResources().configureAction(this, ID);
    }

    @Override
    protected void onActionPerformed(@NonNull ActionEvent event, @NonNull Application app) {
        SimpleWorkState workState = new SimpleWorkState(this.getLabel());
        app.addDisabler(workState);
        int unsavedViewsCount = 0;
        int disabledViewsCount = 0;
        FileBasedActivity documentToBeReviewed = null;
        URI unsavedURI = null;
        for (Activity pr : app.getActivities()) {
            FileBasedActivity p = (FileBasedActivity)pr;
            if (p.isDisabled()) {
                ++disabledViewsCount;
            }
            if (!p.isModified()) continue;
            if (!p.isDisabled()) {
                documentToBeReviewed = p;
            }
            unsavedURI = p.getURI();
            ++unsavedViewsCount;
        }
        if (unsavedViewsCount > 0 && documentToBeReviewed == null) {
            app.removeDisabler(workState);
            return;
        }
        Resources labels = ApplicationLabels.getResources();
        block0 : switch (unsavedViewsCount) {
            case 0: {
                this.doExit((WorkState<Void>)workState);
                break;
            }
            case 1: {
                this.reviewNext((WorkState<Void>)workState);
                break;
            }
            default: {
                ButtonType[] options = new ButtonType[]{new ButtonType(labels.getString("application.exit.reviewChangesOption.text"), ButtonBar.ButtonData.YES), new ButtonType(labels.getString("application.exit.cancelOption.text"), ButtonBar.ButtonData.CANCEL_CLOSE), new ButtonType(labels.getString("application.exit.discardChangesOption.text"), ButtonBar.ButtonData.NO)};
                Alert alert = new Alert(Alert.AlertType.CONFIRMATION, labels.getString("application.exit.doYouWantToReview.details"), options);
                alert.setHeaderText(labels.getFormatted("application.exit.doYouWantToReview.message", unsavedViewsCount));
                Optional result = alert.showAndWait();
                if (result.isPresent()) {
                    switch (((ButtonType)result.get()).getButtonData()) {
                        default: {
                            app.removeDisabler(workState);
                            break block0;
                        }
                        case NO: {
                            app.exit();
                            break block0;
                        }
                        case YES: 
                    }
                    this.unsavedView = documentToBeReviewed;
                    this.reviewChanges((WorkState<Void>)workState);
                    break;
                }
                app.removeDisabler(workState);
            }
        }
    }

    protected @Nullable URIChooser getChooser(FileBasedActivity view) {
        URIChooser chooser = (URIChooser)this.app.get((MapAccessor)AbstractSaveFileAction.SAVE_CHOOSER_KEY);
        if (chooser == null) {
            Supplier factory = (Supplier)this.app.get((MapAccessor)AbstractSaveFileAction.SAVE_CHOOSER_FACTORY_KEY);
            chooser = factory == null ? new FileURIChooser(FileURIChooser.Mode.SAVE) : (URIChooser)factory.get();
            this.app.set((MapAccessor)AbstractSaveFileAction.SAVE_CHOOSER_KEY, chooser);
        }
        return chooser;
    }

    protected void reviewChanges(WorkState<Void> workState) {
        FileBasedActivity unsavedViewLocalVariable = this.unsavedView;
        if (unsavedViewLocalVariable != null && !unsavedViewLocalVariable.isDisabled()) {
            Resources labels = ApplicationLabels.getResources();
            this.oldFocusOwner = unsavedViewLocalVariable.getNode().getScene().getFocusOwner();
            unsavedViewLocalVariable.removeDisabler(workState);
            URI unsavedURI = unsavedViewLocalVariable.getURI();
            ButtonType[] options = new ButtonType[]{new ButtonType(labels.getString("application.exit.saveOption.text"), ButtonBar.ButtonData.YES), new ButtonType(labels.getString("application.exit.cancelOption.text"), ButtonBar.ButtonData.CANCEL_CLOSE), new ButtonType(labels.getString("application.exit.dontSaveOption.text"), ButtonBar.ButtonData.NO)};
            Alert alert = new Alert(Alert.AlertType.CONFIRMATION, labels.getString("application.exit.doYouWantToSave.details"), options);
            alert.getDialogPane().setMaxWidth(640.0);
            alert.setHeaderText(labels.getFormatted("application.exit.doYouWantToSave.message", unsavedViewLocalVariable.getTitle(), unsavedViewLocalVariable.getDisambiguation()));
            unsavedViewLocalVariable.getNode().getScene().getWindow().requestFocus();
            alert.initOwner(unsavedViewLocalVariable.getNode().getScene().getWindow());
            Optional result = alert.showAndWait();
            if (result.isPresent()) {
                switch (((ButtonType)result.get()).getButtonData()) {
                    default: {
                        unsavedViewLocalVariable.removeDisabler(workState);
                        this.getApplication().removeDisabler(workState);
                        break;
                    }
                    case NO: {
                        this.getApplication().getActivities().remove((Object)unsavedViewLocalVariable);
                        unsavedViewLocalVariable.removeDisabler(workState);
                        this.reviewNext(workState);
                        break;
                    }
                    case YES: {
                        this.saveChangesAndReviewNext(workState);
                        break;
                    }
                }
            } else {
                unsavedViewLocalVariable.removeDisabler(workState);
                this.getApplication().removeDisabler(workState);
            }
        } else {
            this.getApplication().removeDisabler(workState);
        }
    }

    protected void saveChangesAndReviewNext(WorkState<Void> workState) {
        FileBasedActivity v = this.unsavedView;
        if (v.getURI() == null) {
            URIChooser chooser = this.getChooser(v);
            URI uri = chooser.showDialog(this.unsavedView.getNode());
            if (uri != null) {
                this.saveToFileAndReviewNext(uri, chooser.getDataFormat(), workState);
            } else {
                v.removeDisabler(workState);
                if (this.oldFocusOwner != null) {
                    this.oldFocusOwner.requestFocus();
                }
                this.getApplication().removeDisabler(workState);
            }
        } else {
            this.saveToFileAndReviewNext(v.getURI(), v.getDataFormat(), workState);
        }
    }

    protected void reviewNext(WorkState<Void> workState) {
        int unsavedViewsCount = 0;
        FileBasedActivity documentToBeReviewed = null;
        for (Activity pr : this.getApplication().getActivities()) {
            FileBasedActivity p = (FileBasedActivity)pr;
            if (!p.isModified()) continue;
            if (!p.isDisabled()) {
                documentToBeReviewed = p;
            }
            ++unsavedViewsCount;
        }
        if (unsavedViewsCount == 0) {
            this.doExit(workState);
        } else if (documentToBeReviewed != null) {
            this.unsavedView = documentToBeReviewed;
            this.reviewChanges(workState);
        } else {
            this.getApplication().removeDisabler(workState);
        }
    }

    protected void saveToFile(@NonNull URI uri, DataFormat format, WorkState<Void> workState) {
        FileBasedActivity v = this.unsavedView;
        if (v == null) {
            return;
        }
        v.write(uri, format, (ImmutableMap<Key<?>, Object>)ChampMap.of(), workState).handle((? super T result, Throwable exception) -> {
            if (exception instanceof CancellationException) {
                v.removeDisabler(this);
                if (this.oldFocusOwner != null) {
                    this.oldFocusOwner.requestFocus();
                }
            } else if (exception != null) {
                String message = exception.getMessage() != null ? exception.getMessage() : exception.toString();
                Resources labels = ApplicationLabels.getResources();
                Alert alert = new Alert(Alert.AlertType.ERROR, labels.getFormatted("file.save.couldntSave.message", UriUtil.getName((URI)uri)) + "</b><p>" + (message == null ? "" : message), new ButtonType[0]);
                alert.getDialogPane().setMaxWidth(640.0);
                alert.showAndWait();
                v.removeDisabler(workState);
                if (this.oldFocusOwner != null) {
                    this.oldFocusOwner.requestFocus();
                }
            } else {
                v.setURI(uri);
                v.clearModified();
                this.app.getRecentUris().put((Object)uri, (Object)format);
            }
            return null;
        });
    }

    protected void saveToFileAndReviewNext(@NonNull URI uri, DataFormat format, WorkState<Void> workState) {
        FileBasedActivity v = this.unsavedView;
        if (v == null) {
            return;
        }
        v.write(uri, format, (ImmutableMap<Key<?>, Object>)ChampMap.of(), workState).handle((? super T result, Throwable exception) -> {
            if (exception instanceof CancellationException) {
                v.removeDisabler(workState);
                if (this.oldFocusOwner != null) {
                    this.oldFocusOwner.requestFocus();
                }
            } else if (exception != null) {
                Throwable value = exception.getCause();
                String message = value != null && value.getMessage() != null ? value.getMessage() : value.toString();
                Resources labels = ApplicationLabels.getResources();
                Alert alert = new Alert(Alert.AlertType.ERROR, labels.getFormatted("file.save.couldntSave.message", UriUtil.getName((URI)uri)) + "</b><p>" + (message == null ? "" : message), new ButtonType[0]);
                alert.getDialogPane().setMaxWidth(640.0);
                alert.showAndWait();
                v.removeDisabler(workState);
                if (this.oldFocusOwner != null) {
                    this.oldFocusOwner.requestFocus();
                }
            } else {
                v.setURI(uri);
                v.clearModified();
                this.reviewNext(workState);
            }
            return null;
        });
    }

    protected void doExit(WorkState<Void> workState) {
        for (Activity pr : new ArrayList<Activity>((Collection<Activity>)this.app.getActivities())) {
            FileBasedActivity p = (FileBasedActivity)pr;
            if (p.isDisabled() || p.isModified()) continue;
            this.app.getActivities().remove((Object)p);
        }
        if (this.app.getActivities().isEmpty()) {
            this.app.exit();
        } else {
            this.app.removeDisabler(workState);
        }
    }
}

