/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.application.action.edit;

import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.scene.Node;
import javafx.scene.control.TextInputControl;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.application.Activity;
import org.jhotdraw8.application.Application;
import org.jhotdraw8.application.EditableComponent;
import org.jhotdraw8.application.action.AbstractApplicationAction;

public abstract class AbstractSelectionAction
extends AbstractApplicationAction {
    private final @Nullable Node target;

    public AbstractSelectionAction(@NonNull Application application) {
        this(application, null);
    }

    public AbstractSelectionAction(@NonNull Application application, @Nullable Node target) {
        super(application);
        this.target = target;
    }

    public @Nullable EditableComponent getEditableComponent() {
        if (this.target != null) {
            return this.tryAsEditableComponent(this.target);
        }
        Activity v = this.app.getActiveActivity();
        if (v != null && !v.isDisabled()) {
            for (Node n = v.getNode().getScene().getFocusOwner(); n != null; n = n.getParent()) {
                EditableComponent editableComponent = this.tryAsEditableComponent(n);
                if (editableComponent == null) continue;
                return editableComponent;
            }
        }
        return null;
    }

    private @Nullable EditableComponent tryAsEditableComponent(Node n) {
        if (n instanceof TextInputControl) {
            TextInputControl tic = (TextInputControl)n;
            return new TextInputControlAdapter(tic);
        }
        if (n instanceof EditableComponent) {
            EditableComponent tic = (EditableComponent)n;
            return tic;
        }
        Object object = n.getProperties().get((Object)"editableComponent");
        if (object instanceof EditableComponent) {
            EditableComponent tic = (EditableComponent)object;
            return tic;
        }
        return null;
    }

    @Override
    protected final void onActionPerformed(@NonNull ActionEvent event, @NonNull Application application) {
        EditableComponent ec = this.getEditableComponent();
        if (ec != null) {
            this.onActionPerformed(event, ec);
        }
    }

    protected abstract void onActionPerformed(ActionEvent var1, EditableComponent var2);

    private record TextInputControlAdapter(@NonNull TextInputControl control) implements EditableComponent
    {
        @Override
        public void clearSelection() {
            this.control.selectRange(this.control.getCaretPosition(), this.control.getCaretPosition());
        }

        @Override
        public void copy() {
            this.control.copy();
        }

        @Override
        public void cut() {
            this.control.cut();
        }

        @Override
        public void deleteSelection() {
            this.control.deleteText(this.control.getSelection());
        }

        @Override
        public void duplicateSelection() {
            this.control.insertText(this.control.getCaretPosition(), this.control.getSelectedText());
        }

        @Override
        public void paste() {
            this.control.paste();
        }

        @Override
        public void selectAll() {
            this.control.selectAll();
        }

        @Override
        public @NonNull ReadOnlyBooleanProperty selectionEmptyProperty() {
            ReadOnlyBooleanWrapper p = new ReadOnlyBooleanWrapper();
            p.bind((ObservableValue)this.control.selectedTextProperty().isNull());
            return p.getReadOnlyProperty();
        }
    }
}

