/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.application.action.file;

import java.lang.reflect.Type;
import java.net.URI;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.SequencedMap;
import java.util.concurrent.CancellationException;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.event.ActionEvent;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.input.DataFormat;
import javafx.stage.Modality;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.application.ApplicationLabels;
import org.jhotdraw8.application.FileBasedActivity;
import org.jhotdraw8.application.action.AbstractActivityAction;
import org.jhotdraw8.application.controls.urichooser.FileURIChooser;
import org.jhotdraw8.application.controls.urichooser.URIChooser;
import org.jhotdraw8.application.resources.Resources;
import org.jhotdraw8.base.net.UriUtil;
import org.jhotdraw8.fxbase.concurrent.SimpleWorkState;
import org.jhotdraw8.fxbase.concurrent.WorkState;
import org.jhotdraw8.fxcollection.typesafekey.Key;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jhotdraw8.fxcollection.typesafekey.NullableObjectKey;
import org.jhotdraw8.fxcollection.typesafekey.SimpleParameterizedType;
import org.jhotdraw8.icollection.ChampMap;
import org.jhotdraw8.icollection.immutable.ImmutableMap;

public abstract class AbstractSaveFileAction
extends AbstractActivityAction<FileBasedActivity> {
    private final boolean saveAs;
    private Node oldFocusOwner;
    public static final @NonNull Key<URIChooser> SAVE_CHOOSER_KEY = new NullableObjectKey("saveChooser", URIChooser.class);
    public static final @NonNull Key<Supplier<URIChooser>> SAVE_CHOOSER_FACTORY_KEY = new NullableObjectKey("saveChooserFactory", (Type)new SimpleParameterizedType(Supplier.class, new Type[]{URIChooser.class}));

    public AbstractSaveFileAction(@NonNull FileBasedActivity activity, String id, boolean saveAs) {
        this(activity, id, saveAs, activity.getApplication().getResources());
    }

    public AbstractSaveFileAction(@NonNull FileBasedActivity activity, @NonNull String id, boolean saveAs, @NonNull Resources resources) {
        super(activity);
        this.saveAs = saveAs;
        resources.configureAction(this, id);
    }

    protected @NonNull URIChooser getChooser(FileBasedActivity view) {
        URIChooser chooser = (URIChooser)this.app.get((MapAccessor)SAVE_CHOOSER_KEY);
        if (chooser == null) {
            Supplier factory = (Supplier)this.app.get((MapAccessor)SAVE_CHOOSER_FACTORY_KEY);
            chooser = factory == null ? new FileURIChooser(FileURIChooser.Mode.SAVE) : (URIChooser)factory.get();
            this.app.set((MapAccessor)SAVE_CHOOSER_KEY, chooser);
        }
        return chooser;
    }

    @Override
    protected void onActionPerformed(@NonNull ActionEvent evt, @NonNull FileBasedActivity activity) {
        this.oldFocusOwner = activity.getNode().getScene().getFocusOwner();
        SimpleWorkState workState = new SimpleWorkState(this.getLabel());
        activity.addDisabler(workState);
        this.saveFileChooseUri(activity, (WorkState<Void>)workState);
    }

    protected void saveFileChooseUri(@NonNull FileBasedActivity v, WorkState<Void> workState) {
        if (v.getURI() == null || this.saveAs) {
            URIChooser chsr = this.getChooser(v);
            URI uri = chsr.showDialog(v.getNode());
            if (uri != null) {
                this.saveFileChooseOptions(v, uri, chsr.getDataFormat(), workState);
            } else {
                v.removeDisabler(workState);
            }
            if (this.oldFocusOwner != null) {
                this.oldFocusOwner.requestFocus();
            }
        } else {
            this.saveFileChooseOptions(v, v.getURI(), v.getDataFormat(), workState);
        }
    }

    protected void saveFileChooseOptions(@NonNull FileBasedActivity v, @NonNull URI uri, DataFormat format, WorkState<Void> workState) {
        SequencedMap<Object, Object> options = new LinkedHashMap();
        Dialog<SequencedMap<Key<?>, Object>> dialog = null;
        try {
            dialog = this.createOptionsDialog(format);
        }
        catch (RuntimeException e) {
            Alert alert = new Alert(Alert.AlertType.ERROR, this.createErrorMessage(e), new ButtonType[0]);
            alert.getDialogPane().setMaxWidth(640.0);
            Resources labels = ApplicationLabels.getResources();
            alert.setHeaderText(labels.getFormatted("file.save.couldntSave.message", UriUtil.getName((URI)uri)));
            alert.showAndWait();
            v.removeDisabler(this);
            return;
        }
        if (dialog != null) {
            dialog.initModality(Modality.WINDOW_MODAL);
            dialog.initOwner(v.getNode().getScene().getWindow());
            Optional result = dialog.showAndWait();
            if (result.isPresent()) {
                options = (SequencedMap)result.get();
            } else {
                v.removeDisabler(workState);
                return;
            }
        }
        this.saveFileToUri(v, uri, format, options, workState);
    }

    protected void saveFileToUri(@NonNull FileBasedActivity view, @NonNull URI uri, DataFormat format, @NonNull Map<Key<?>, Object> options, WorkState<Void> workState) {
        view.write(uri, format, (ImmutableMap<Key<?>, Object>)ChampMap.copyOf(options), workState).handle((? super T result, Throwable exception) -> {
            if (exception instanceof CancellationException) {
                view.removeDisabler(workState);
                if (this.oldFocusOwner != null) {
                    this.oldFocusOwner.requestFocus();
                }
            } else if (exception != null) {
                Throwable value = exception;
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Unexpected Exception " + value.getMessage(), value);
                Resources labels = ApplicationLabels.getResources();
                Alert alert = new Alert(Alert.AlertType.ERROR, this.createErrorMessage((Throwable)exception), new ButtonType[0]);
                alert.getDialogPane().setMaxWidth(640.0);
                alert.setHeaderText(labels.getFormatted("file.save.couldntSave.message", UriUtil.getName((URI)uri)));
                alert.showAndWait();
                view.removeDisabler(workState);
                if (this.oldFocusOwner != null) {
                    this.oldFocusOwner.requestFocus();
                }
            } else {
                this.onSaveSucceeded(view, uri, format);
                view.removeDisabler(workState);
                if (this.oldFocusOwner != null) {
                    this.oldFocusOwner.requestFocus();
                }
            }
            return null;
        });
    }

    protected @Nullable Dialog<SequencedMap<Key<?>, Object>> createOptionsDialog(DataFormat format) {
        return null;
    }

    protected abstract void onSaveSucceeded(FileBasedActivity var1, URI var2, DataFormat var3);
}

