/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.application.action.file;

import java.awt.Desktop;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.event.ActionEvent;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.application.FileBasedActivity;
import org.jhotdraw8.application.action.AbstractActivityAction;

public class BrowseFileDirectoryAction
extends AbstractActivityAction<FileBasedActivity> {
    public static final String ID = "file.browseFileDirectory";

    public BrowseFileDirectoryAction(@NonNull FileBasedActivity activity) {
        super(activity);
        activity.getApplication().getResources().configureAction(this, ID);
    }

    @Override
    protected void onActionPerformed(@NonNull ActionEvent event, @NonNull FileBasedActivity activity) {
        if (this.isDisabled()) {
            return;
        }
        URI uri = activity.getURI();
        this.doIt(uri);
    }

    private void doIt(@Nullable URI uri) {
        BrowseFileDirectoryAction.browseFileDirectory(uri);
    }

    public static void browseFileDirectory(@Nullable URI uri) {
        if (uri == null) {
            return;
        }
        try {
            Path path = Paths.get(uri);
            try {
                try {
                    Desktop.class.getMethod("browseFileDirectory", File.class).invoke((Object)Desktop.getDesktop(), path.toFile());
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    Logger.getLogger(BrowseFileDirectoryAction.class.getName()).log(Level.WARNING, "Unexpected Exception " + e.getMessage(), e);
                }
            }
            catch (NoSuchMethodException e) {
                Logger.getLogger(BrowseFileDirectoryAction.class.getName()).log(Level.WARNING, "Unexpected Exception " + e.getMessage(), e);
            }
        }
        catch (FileSystemNotFoundException e) {
            Logger.getLogger(BrowseFileDirectoryAction.class.getName()).warning(e.getMessage());
        }
    }
}

