/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.application.action.file;

import java.net.URI;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.event.ActionEvent;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.input.DataFormat;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.application.Activity;
import org.jhotdraw8.application.Application;
import org.jhotdraw8.application.ApplicationLabels;
import org.jhotdraw8.application.FileBasedActivity;
import org.jhotdraw8.application.action.AbstractApplicationAction;
import org.jhotdraw8.application.action.Action;
import org.jhotdraw8.application.resources.Resources;
import org.jhotdraw8.base.net.UriUtil;
import org.jhotdraw8.fxbase.concurrent.SimpleWorkState;
import org.jhotdraw8.fxbase.concurrent.WorkState;
import org.jhotdraw8.fxcollection.typesafekey.Key;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jhotdraw8.icollection.ChampMap;
import org.jhotdraw8.icollection.immutable.ImmutableMap;

public class OpenRecentFileAction
extends AbstractApplicationAction {
    public static final String ID = "file.openRecent";
    private final URI uri;
    private final DataFormat format;
    private final boolean reuseEmptyViews = true;

    public OpenRecentFileAction(Application app, @NonNull URI uri, DataFormat format) {
        super(app);
        this.uri = uri;
        this.format = format;
        this.set((MapAccessor)Action.LABEL, UriUtil.getName((URI)uri));
    }

    @Override
    protected void onActionPerformed(@NonNull ActionEvent evt, @NonNull Application app) {
        for (Activity activity : app.getActivities()) {
            FileBasedActivity fba = (FileBasedActivity)activity;
            if (!Objects.equals(this.uri, fba.getURI())) continue;
            fba.getNode().getScene().getWindow().requestFocus();
            return;
        }
        FileBasedActivity emptyView = (FileBasedActivity)app.getActiveActivity();
        if (emptyView == null || !emptyView.isEmpty() || emptyView.isDisabled()) {
            emptyView = null;
        }
        if (emptyView == null) {
            app.createActivity().thenAccept(v -> {
                app.getActivities().add(v);
                this.doIt((FileBasedActivity)v, true);
            });
        } else {
            this.doIt(emptyView, false);
        }
    }

    public void doIt(@NonNull FileBasedActivity view, boolean disposeView) {
        this.openViewFromURI(view, this.uri, this.format);
    }

    private void onException(@NonNull FileBasedActivity v, @NonNull Throwable exception) throws MissingResourceException {
        Throwable value = exception;
        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Unexpected Exception " + exception.getMessage(), exception);
        Resources labels = ApplicationLabels.getResources();
        Alert alert = new Alert(Alert.AlertType.ERROR, this.createErrorMessage(exception), new ButtonType[0]);
        alert.getDialogPane().setMaxWidth(640.0);
        alert.setHeaderText(labels.getFormatted("file.open.couldntOpen.message", UriUtil.getName((URI)this.uri)));
        ButtonType removeUri = new ButtonType(labels.getString("file.removeOpenRecentEntry.buttonText"));
        alert.getButtonTypes().add((Object)removeUri);
        v.clear();
        Optional selection = alert.showAndWait();
        if (selection.isPresent() && selection.get() == removeUri) {
            this.getApplication().getRecentUris().remove((Object)this.uri);
        }
    }

    protected void openViewFromURI(@NonNull FileBasedActivity v, @NonNull URI uri, DataFormat format) {
        Application app = this.getApplication();
        SimpleWorkState workState = new SimpleWorkState(this.getLabel());
        v.addDisabler(workState);
        URI oldUri = v.getURI();
        v.setURI(uri);
        try {
            v.read(uri, format, (ImmutableMap<Key<?>, Object>)ChampMap.of(), false, (WorkState<Void>)workState).whenComplete((arg_0, arg_1) -> this.lambda$openViewFromURI$1(v, (WorkState)workState, oldUri, uri, arg_0, arg_1));
        }
        catch (Throwable t) {
            v.removeDisabler(workState);
            this.onException(v, t);
        }
    }

    private /* synthetic */ void lambda$openViewFromURI$1(FileBasedActivity v, WorkState workState, URI oldUri, URI uri, DataFormat actualFormat, Throwable exception) {
        if (exception instanceof CancellationException) {
            v.removeDisabler(workState);
            v.setURI(oldUri);
        } else if (exception != null) {
            v.removeDisabler(workState);
            v.setURI(oldUri);
            this.onException(v, exception);
        } else {
            v.setURI(uri);
            v.setDataFormat(actualFormat);
            v.clearModified();
            v.removeDisabler(workState);
        }
        URI finalUri = v.getURI();
    }
}

