/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.application.action.file;

import java.net.URI;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.event.ActionEvent;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.input.DataFormat;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.application.ApplicationLabels;
import org.jhotdraw8.application.FileBasedActivity;
import org.jhotdraw8.application.action.AbstractActivityAction;
import org.jhotdraw8.fxbase.concurrent.SimpleWorkState;
import org.jhotdraw8.fxbase.concurrent.WorkState;
import org.jhotdraw8.fxcollection.typesafekey.Key;
import org.jhotdraw8.icollection.ChampMap;
import org.jhotdraw8.icollection.immutable.ImmutableMap;

public class RevertFileAction
extends AbstractActivityAction<FileBasedActivity> {
    public static final String ID = "file.revert";

    public RevertFileAction(@NonNull FileBasedActivity view) {
        super(view);
        ApplicationLabels.getResources().configureAction(this, ID);
    }

    @Override
    protected void onActionPerformed(@NonNull ActionEvent event, @NonNull FileBasedActivity activity) {
        if (this.isDisabled()) {
            return;
        }
        URI uri = activity.getURI();
        DataFormat dataFormat = activity.getDataFormat();
        if (activity.isModified()) {
            Alert alert = new Alert(Alert.AlertType.WARNING, ApplicationLabels.getResources().getString("file.revert.doYouWantToRevert.message"), new ButtonType[]{ButtonType.YES, ButtonType.CANCEL});
            alert.getDialogPane().setMaxWidth(640.0);
            Optional answer = alert.showAndWait();
            if (answer.isPresent() && answer.get() == ButtonType.YES) {
                this.doIt(activity, uri, dataFormat);
            }
        } else {
            this.doIt(activity, uri, dataFormat);
        }
    }

    private void doIt(@NonNull FileBasedActivity view, @Nullable URI uri, DataFormat dataFormat) {
        SimpleWorkState workState = new SimpleWorkState(this.getLabel());
        view.addDisabler(workState);
        BiFunction<DataFormat, Throwable, Void> handler = (arg_0, arg_1) -> this.lambda$doIt$0(view, (WorkState)workState, arg_0, arg_1);
        if (uri == null) {
            view.clear().handle((? super T ignored, Throwable throwable) -> (Void)handler.apply((DataFormat)null, (Throwable)throwable));
        } else {
            view.read(uri, dataFormat, (ImmutableMap<Key<?>, Object>)ChampMap.of(), false, (WorkState<Void>)workState).handle(handler);
        }
    }

    private /* synthetic */ Void lambda$doIt$0(FileBasedActivity view, WorkState workState, DataFormat actualDataFormat, Throwable throwable) {
        if (throwable != null) {
            Alert alert = new Alert(Alert.AlertType.ERROR, this.createErrorMessage(throwable), new ButtonType[0]);
            alert.getDialogPane().setMaxWidth(640.0);
            alert.showAndWait();
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Unexpected Exception " + throwable.getMessage(), throwable);
        }
        view.clearModified();
        view.removeDisabler(workState);
        return null;
    }
}

