/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.application.resources;

import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.application.resources.LocaleUtil;
import org.jhotdraw8.application.resources.Resources;

public class ClasspathResources
extends ResourceBundle
implements Serializable,
Resources {
    private static final Logger LOG = Logger.getLogger(ClasspathResources.class.getName());
    private static final long serialVersionUID = 1L;
    private final Class<?> baseClass = this.getClass();
    private final @NonNull String baseName;
    private final @NonNull Locale locale;
    private @Nullable Resources parent;
    private final transient ResourceBundle resource;

    public ClasspathResources(@NonNull String baseName, @NonNull Locale locale) {
        this.locale = locale;
        this.baseName = baseName;
        this.resource = ResourceBundle.getBundle(baseName, locale);
        ClasspathResources potentialParent = null;
        String moduleAndParentBaseName = null;
        try {
            moduleAndParentBaseName = this.resource.getString("$parent");
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        if (moduleAndParentBaseName != null) {
            String[] split = moduleAndParentBaseName.split("\\s+|\\s*,\\s*");
            String parentBaseName = switch (split.length) {
                case 1 -> {
                    String moduleName = "";
                    yield split[0];
                }
                case 2 -> {
                    String moduleName = split[0];
                    yield split[1];
                }
                default -> throw new IllegalArgumentException("Could not parse the value of the property $parent=\"" + moduleAndParentBaseName + "\".");
            };
            try {
                potentialParent = new ClasspathResources(parentBaseName, locale);
            }
            catch (MissingResourceException e) {
                MissingResourceException ex = new MissingResourceException("Could not find a resource bundle with baseName=\"" + baseName + " and locale=\"" + String.valueOf(locale) + "\".", baseName, locale.toString());
                ex.initCause(e);
                throw ex;
            }
        }
        this.parent = potentialParent;
    }

    @Override
    public boolean containsKey(@Nullable String key) {
        Objects.requireNonNull(key, "key");
        if (this.resource.containsKey(key)) {
            return true;
        }
        if (this.parent != null) {
            return this.parent.containsKey(key);
        }
        LOG.warning("Could not find a resource with key=\"" + key + "\" in resource bundle \"" + this.baseName + "\".");
        return false;
    }

    @Override
    public Class<?> getBaseClass() {
        return this.baseClass;
    }

    @Override
    public @Nullable Object getModule() {
        return null;
    }

    @Override
    protected @Nullable Object handleGetObject(@NonNull String key) {
        Object obj = this.handleGetObjectRecursively(key);
        if (obj == null) {
            obj = "";
            LOG.warning("Can't find resource for bundle " + this.baseName + ", key " + key);
        }
        if (obj instanceof String) {
            obj = this.substitutePlaceholders(key, (String)obj);
        }
        return obj;
    }

    @Override
    public @Nullable Object handleGetObjectRecursively(@NonNull String key) {
        Object obj;
        block2: {
            obj = null;
            try {
                obj = this.resource.getObject(key);
            }
            catch (MissingResourceException e) {
                if (this.parent == null) break block2;
                return this.parent.handleGetObjectRecursively(key);
            }
        }
        return obj;
    }

    public @NonNull String toString() {
        return "ClasspathResources[" + this.baseName + "]";
    }

    @Override
    public @NonNull String getBaseName() {
        return this.baseName;
    }

    public static @NonNull Resources getResources(@NonNull String baseName) throws MissingResourceException {
        return ClasspathResources.getResources(baseName, LocaleUtil.getDefault());
    }

    static Resources getResources(@NonNull String baseName, @NonNull Locale locale) throws MissingResourceException {
        ClasspathResources r = new ClasspathResources(baseName, locale);
        return r;
    }

    @Override
    public @NonNull ResourceBundle asResourceBundle() {
        return this;
    }

    @Override
    public @NonNull Locale getLocale() {
        return super.getLocale();
    }

    @Override
    public @NonNull Enumeration<String> getKeys() {
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        Enumeration<String> i = this.resource.getKeys();
        while (i.hasMoreElements()) {
            keys.add(i.nextElement());
        }
        if (this.parent != null) {
            i = this.parent.getKeys();
            while (i.hasMoreElements()) {
                keys.add(i.nextElement());
            }
        }
        return Collections.enumeration(keys);
    }

    @Override
    public @Nullable Resources getParent() {
        return this.parent;
    }

    @Override
    public void setParent(@Nullable Resources parent) {
        this.parent = parent;
    }
}

