/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.application.resources;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Formatter;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import javafx.scene.Node;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Tooltip;
import javafx.scene.input.KeyCombination;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.application.action.Action;
import org.jhotdraw8.application.resources.ClasspathResources;
import org.jhotdraw8.application.resources.ResourceDecoder;
import org.jhotdraw8.application.resources.ResourcesHelper;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;

public interface Resources {
    public static final String PARENT_RESOURCE_KEY = "$parent";

    public static void addDecoder(ResourceDecoder decoder) {
        ResourcesHelper.decoders.add(decoder);
    }

    public static void putPropertyNameModifier(String name, String ... fallbackChain) {
        ResourcesHelper.propertyNameModifiers.put(name, fallbackChain);
    }

    public static void removePropertyNameModifier(String name) {
        ResourcesHelper.propertyNameModifiers.remove(name);
    }

    public static @NonNull Resources getResources(String moduleName, @NonNull String resourceBundle) {
        try {
            Class<?> clazz = Class.forName("org.jhotdraw8.application.resources.ModulepathResources");
            Method method = clazz.getMethod("getResources", String.class, String.class);
            return (Resources)method.invoke(null, moduleName, resourceBundle);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException e) {
            return ClasspathResources.getResources(resourceBundle);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof MissingResourceException) {
                throw (MissingResourceException)cause;
            }
            return ClasspathResources.getResources(resourceBundle);
        }
    }

    public ResourceBundle asResourceBundle();

    default public void configureAction(@NonNull Action action, String argument) {
        this.configureAction(action, argument, this.getBaseClass());
    }

    default public void configureAction(@NonNull Action action, String argument, @NonNull Class<?> baseClass) {
        action.set((MapAccessor)Action.LABEL, this.getTextProperty(argument));
        String shortDescription = this.getToolTipTextProperty(argument);
        if (shortDescription != null && !shortDescription.isEmpty()) {
            action.set((MapAccessor)Action.SHORT_DESCRIPTION, shortDescription);
        }
        action.set((MapAccessor)Action.ACCELERATOR_KEY, this.getAcceleratorProperty(argument));
        action.set((MapAccessor)Action.MNEMONIC_KEY, this.getMnemonicProperty(argument));
        action.set((MapAccessor)Action.SMALL_ICON, this.getSmallIconProperty(argument, baseClass));
        action.set((MapAccessor)Action.LARGE_ICON_KEY, this.getLargeIconProperty(argument, baseClass));
    }

    default public void configureButton(@NonNull ButtonBase button, String argument) {
        this.configureButton(button, argument, this.getBaseClass());
    }

    default public void configureButton(@NonNull ButtonBase button, String argument, @NonNull Class<?> baseClass) {
        button.setText(this.getTextProperty(argument));
        button.setGraphic(this.getLargeIconProperty(argument, baseClass));
        button.setTooltip(new Tooltip(this.getToolTipTextProperty(argument)));
    }

    default public void configureMenu(@NonNull Menu menu, String argument) {
        menu.setText(this.getTextProperty(argument));
        menu.setAccelerator(this.getAcceleratorProperty(argument));
        menu.setGraphic(this.getSmallIconProperty(argument, this.getBaseClass()));
    }

    default public void configureMenuItem(@NonNull MenuItem menu, String argument) {
        menu.setText(this.getTextProperty(argument));
        menu.setAccelerator(this.getAcceleratorProperty(argument));
        menu.setGraphic(this.getSmallIconProperty(argument, this.getBaseClass()));
    }

    default public void configureToolBarButton(@NonNull ButtonBase button, String argument) {
        this.configureToolBarButton(button, argument, this.getBaseClass());
    }

    default public void configureToolBarButton(@NonNull ButtonBase button, String argument, @NonNull Class<?> baseClass) {
        Node icon = this.getLargeIconProperty(argument, baseClass);
        if (icon != null) {
            button.setGraphic(this.getLargeIconProperty(argument, baseClass));
            button.setText(null);
        } else {
            button.setGraphic(null);
            button.setText(this.getTextProperty(argument));
        }
        button.setTooltip(new Tooltip(this.getToolTipTextProperty(argument)));
    }

    public boolean containsKey(String var1);

    default public @NonNull String format(@NonNull String key, Object ... arguments) {
        return new Formatter(this.getLocale()).format(this.getString(key), arguments).toString();
    }

    default public @NonNull String messageFormat(@NonNull String key, Object ... arguments) {
        return new MessageFormat(this.getString(key), this.getLocale()).format(arguments);
    }

    default public @Nullable KeyCombination getAcceleratorProperty(String key) {
        return this.getKeyCombination(key + ".accelerator");
    }

    public Class<?> getBaseClass();

    public Object getModule();

    public @NonNull String getBaseName();

    default public @NonNull String getFormatted(@NonNull String key, Object ... arguments) {
        return MessageFormat.format(this.getString(key), arguments);
    }

    default public @NonNull Integer getInteger(@NonNull String key) {
        try {
            return Integer.valueOf(this.getString(key));
        }
        catch (MissingResourceException e) {
            ResourcesHelper.LOG.warning("ClasspathResources[" + this.getBaseName() + "] \"" + key + "\" not found.");
            return -1;
        }
    }

    default public @Nullable KeyCombination getKeyCombination(@NonNull String key) {
        KeyCombination ks = null;
        String s = this.getString(key);
        try {
            ks = s == null || s.isEmpty() ? null : KeyCombination.valueOf((String)this.translateKeyStrokeToKeyCombination(s));
        }
        catch (StringIndexOutOfBoundsException | NoSuchElementException e) {
            throw new InternalError(key + "=" + s, e);
        }
        return ks;
    }

    default public @Nullable Node getLargeIconProperty(String key, @NonNull Class<?> baseClass) {
        return ResourcesHelper.getIconProperty(this, key, ".largeIcon", baseClass);
    }

    public @NonNull Locale getLocale();

    default public char getMnemonic(@NonNull String key) {
        String s = this.getString(key);
        return s == null || s.isEmpty() ? (char)'\u0000' : s.charAt(0);
    }

    default public @Nullable KeyCombination getMnemonicProperty(String key) {
        String s;
        try {
            s = this.getString(key + ".mnemonic");
        }
        catch (MissingResourceException e) {
            ResourcesHelper.LOG.warning("Warning ClasspathResources[" + this.getBaseName() + "] \"" + key + ".mnemonic\" not found.");
            s = null;
        }
        return s == null || s.isEmpty() ? null : KeyCombination.valueOf((String)s);
    }

    default public @Nullable Node getSmallIconProperty(String key, @NonNull Class<?> baseClass) {
        return ResourcesHelper.getIconProperty(this, key, ".smallIcon", baseClass);
    }

    public @NonNull String getString(String var1);

    default public @Nullable String getTextProperty(String key) {
        try {
            String value = this.getString(key + ".text");
            return value;
        }
        catch (MissingResourceException e) {
            ResourcesHelper.LOG.warning("Warning ClasspathResources[" + this.getBaseName() + "] \"" + key + ".text\" not found.");
            return null;
        }
    }

    default public @Nullable String getToolTipTextProperty(String key) {
        try {
            String value = this.getString(key + ".toolTipText");
            return value;
        }
        catch (MissingResourceException e) {
            ResourcesHelper.LOG.warning("Resources[" + this.getBaseName() + "] \"" + key + ".toolTipText\" not found.");
            return null;
        }
    }

    default public @NonNull String substitutePlaceholders(String key, @NonNull String value) throws MissingResourceException {
        int p2;
        int p1 = ((String)value).indexOf("${");
        while (p1 != -1 && (p2 = ((String)value).indexOf(125, p1 + 2)) >= 0) {
            String placeholderFormat;
            String placeholderKey = ((String)value).substring(p1 + 2, p2);
            int p3 = placeholderKey.indexOf(44);
            if (p3 != -1) {
                placeholderFormat = placeholderKey.substring(p3 + 1);
                placeholderKey = placeholderKey.substring(0, p3);
            } else {
                placeholderFormat = "string";
            }
            ArrayList<String> fallbackKeys = new ArrayList<String>();
            ResourcesHelper.generateFallbackKeys(placeholderKey, fallbackKeys);
            String placeholderValue = null;
            for (String fk : fallbackKeys) {
                try {
                    placeholderValue = this.getString(fk);
                    break;
                }
                catch (MissingResourceException missingResourceException) {
                }
            }
            if (placeholderValue == null) {
                throw new MissingResourceException("Could not find the placeholder value for key=\"" + key + "\", value=\"" + (String)value + "\", placeholderKey=\"" + placeholderKey + "\".", this.getBaseName(), key);
            }
            if ("accelerator".equals(placeholderFormat)) {
                StringBuilder b = new StringBuilder();
                for (String s : placeholderValue.split(" ")) {
                    if (ResourcesHelper.acceleratorKeys.contains(s)) {
                        b.append(this.getString("accelerator." + s));
                        continue;
                    }
                    b.append(s);
                }
                placeholderValue = b.toString();
            }
            value = ((String)value).substring(0, p1) + placeholderValue + ((String)value).substring(p2 + 1);
            p1 = ((String)value).indexOf("${");
        }
        return value;
    }

    default public @Nullable String translateKeyStrokeToKeyCombination(@Nullable String s) {
        if (s != null) {
            s = s.replace("ctrl ", "Ctrl+");
            s = s.replace("meta ", "Meta+");
            s = s.replace("alt ", "Alt+");
            s = s.replace("shift ", "Shift+");
        }
        return s;
    }

    public @Nullable Object handleGetObjectRecursively(@NonNull String var1);

    public @NonNull Enumeration<String> getKeys();

    public @Nullable Resources getParent();

    public void setParent(@Nullable Resources var1);

    default public @NonNull Resources getRoot() {
        Resources root = this;
        while (root.getParent() != null) {
            root = root.getParent();
        }
        return root;
    }
}

