/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.application.resources;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.scene.Node;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.application.resources.ResourceDecoder;
import org.jhotdraw8.application.resources.Resources;
import org.jhotdraw8.fxbase.spi.NodeReader;
import org.jhotdraw8.fxbase.spi.NodeReaderRegistry;

class ResourcesHelper {
    static final Logger LOG = Logger.getLogger(Resources.class.getName());
    static final @NonNull Map<String, String[]> propertyNameModifiers = Collections.synchronizedMap(new HashMap());
    static final Set<String> acceleratorKeys;
    static final @NonNull List<ResourceDecoder> decoders;

    ResourcesHelper() {
    }

    static void generateFallbackKeys(@NonNull String key, @NonNull ArrayList<String> fallbackKeys) {
        int p1 = key.indexOf("[$");
        if (p1 < 0) {
            fallbackKeys.add(key);
        } else {
            int p2 = key.indexOf(93, p1 + 2);
            if (p2 < 0) {
                return;
            }
            String modifierKey = key.substring(p1 + 2, p2);
            String[] modifierValues = propertyNameModifiers.get(modifierKey);
            if (modifierValues == null) {
                modifierValues = new String[]{"default"};
            }
            for (String mv : modifierValues) {
                ResourcesHelper.generateFallbackKeys(key.substring(0, p1) + mv + key.substring(p2 + 1), fallbackKeys);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static @Nullable Node getIconProperty(@NonNull Resources r, String key, String suffix, @NonNull Class<?> baseClass) {
        try {
            URL url;
            NodeReader reader;
            String rsrcName;
            block16: {
                rsrcName = r.getString(key + suffix);
                if (rsrcName.isEmpty()) {
                    return null;
                }
                for (ResourceDecoder d : decoders) {
                    if (!d.canDecodeValue(key, rsrcName, Node.class)) continue;
                    return d.decode(key, rsrcName, Node.class, baseClass);
                }
                if (r.getModule() != null) {
                    try {
                        Object module = r.getModule();
                        reader = NodeReaderRegistry.getNodeReader((String)rsrcName);
                        if (reader == null) break block16;
                        try (InputStream resourceAsStream = (InputStream)module.getClass().getMethod("getResourceAsStream", String.class).invoke(module, rsrcName);){
                            if (resourceAsStream != null) {
                                Node node = reader.read(resourceAsStream);
                                return node;
                            }
                        }
                    }
                    catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException module) {
                        // empty catch block
                    }
                }
            }
            if ((url = baseClass.getResource(rsrcName)) == null) {
                LOG.warning("Resources[" + r.getBaseName() + "].getIconProperty \"" + key + suffix + "\" resource:" + rsrcName + " not found.");
                return null;
            }
            reader = NodeReaderRegistry.getNodeReader((URL)url);
            if (reader == null) {
                return null;
            }
            Node node = reader.read(url);
            return node;
        }
        catch (IOException | MissingResourceException e) {
            LOG.log(Level.WARNING, "Resources[" + r.getBaseName() + "].getIconProperty \"" + key + suffix + "\" not found.", e);
            return null;
        }
    }

    static {
        String osName = System.getProperty("os.name").toLowerCase();
        String os = osName.startsWith("mac") ? "mac" : (osName.startsWith("windows") ? "win" : "other");
        propertyNameModifiers.put("os", new String[]{os, "default"});
        acceleratorKeys = Collections.synchronizedSet(new HashSet<String>(Arrays.asList("shift", "control", "ctrl", "meta", "alt", "altGraph")));
        decoders = Collections.synchronizedList(new ArrayList());
    }
}

