/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.base.concurrent;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountedCompleter;
import java.util.function.Consumer;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;

public class TileTask
extends CountedCompleter<Void> {
    private final @NonNull Tile tile;
    private final int chunkSize;
    private final @NonNull Consumer<Tile> tileConsumer;
    private final @NonNull CompletableFuture<Void> future;

    public TileTask(@NonNull Tile tile, int chunkSize, @NonNull Consumer<Tile> tileConsumer, @NonNull CompletableFuture<Void> future) {
        this(null, tile, chunkSize, tileConsumer, future);
    }

    TileTask(@Nullable TileTask parent, @NonNull Tile tile, int chunkSize, @NonNull Consumer<Tile> tileConsumer, @NonNull CompletableFuture<Void> future) {
        super(parent, (tile.xto - tile.xfrom + chunkSize - 1) / chunkSize * ((tile.yto - tile.yfrom + chunkSize - 1) / chunkSize) - 1);
        this.chunkSize = chunkSize;
        this.tile = tile;
        this.tileConsumer = tileConsumer;
        this.future = future;
    }

    public static void forEach(int x, int y, int width, int height, int chunkSize, Consumer<Tile> action) {
        new TileTask(null, new Tile(x, y, x + width, y + height), chunkSize, action, new CompletableFuture<Void>()).invoke();
    }

    public static CompletableFuture<Void> fork(int x, int y, int width, int height, int chunkSize, Consumer<Tile> action) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        TileTask rangeTask = new TileTask(null, new Tile(x, y, x + width, y + height), chunkSize, action, future);
        rangeTask.fork();
        return future;
    }

    @Override
    public void compute() {
        if (this.getRoot() == this) {
            for (int y = this.tile.yfrom; y < this.tile.yto; y += this.chunkSize) {
                for (int x = this.tile.xfrom; x < this.tile.xto; x += this.chunkSize) {
                    if (y == 0 && x == 0) continue;
                    new TileTask(this, new Tile(x, y, Math.min(x + this.chunkSize, this.tile.xto), Math.min(y + this.chunkSize, this.tile.yto)), this.chunkSize, this.tileConsumer, this.future).fork();
                }
            }
        }
        if (!this.future.isCancelled()) {
            this.tileConsumer.accept(new Tile(this.tile.xfrom, this.tile.yfrom, Math.min(this.tile.xto, this.tile.xfrom + this.chunkSize), Math.min(this.tile.yto, this.tile.yto + this.chunkSize)));
        }
        this.tryComplete();
    }

    @Override
    public void onCompletion(CountedCompleter<?> caller) {
        if (this.getRoot().getPendingCount() == 0) {
            this.future.complete(null);
        }
    }

    @Override
    public boolean onExceptionalCompletion(Throwable ex, CountedCompleter<?> caller) {
        this.future.completeExceptionally(ex);
        return true;
    }

    public record Tile(int xfrom, int yfrom, int xto, int yto) {
    }
}

