/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.base.net;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;

public class UriUtil {
    private UriUtil() {
    }

    public static String getName(@NonNull URI uri) {
        if (uri.getScheme() != null && "file".equals(uri.getScheme())) {
            Path userHomePath;
            Path file = Paths.get(UriUtil.clearQuery(uri));
            String userHome = System.getProperty("user.home");
            boolean isInsideHome = false;
            if (userHome != null && file.startsWith(userHomePath = Paths.get(userHome, new String[0]))) {
                file = userHomePath.relativize(file);
                isInsideHome = true;
            }
            return String.valueOf(file.getFileName()) + " [" + (String)(isInsideHome ? "~" + File.separatorChar : "") + String.valueOf(file.getParent()) + "]";
        }
        return uri.toString();
    }

    public static URI addQuery(@NonNull URI uri, @Nullable String key, @Nullable String value) {
        if (key == null || value == null) {
            return uri;
        }
        if (key.indexOf(61) != -1 || key.indexOf(38) != -1) {
            throw new IllegalArgumentException("Can not add a key that contains the characters '&' or '='. key=\"" + key + "\".");
        }
        if (value.indexOf(61) != -1 || value.indexOf(38) != -1) {
            throw new IllegalArgumentException("Can not add a value that contains the characters '&' or '='. value=\"" + value + "\".");
        }
        return UriUtil.addQuery(uri, key + "=" + value);
    }

    public static URI addQuery(@NonNull URI uri, @Nullable String query) {
        if (query == null) {
            return uri;
        }
        if (query.indexOf(38) != -1 || query.indexOf(61) != -1) {
            throw new IllegalArgumentException("Can not add a query that contains the characters '&' or '='. query=\"" + query + "\".");
        }
        String oldQuery = uri.getQuery();
        String newQuery = oldQuery == null ? query : oldQuery + "&" + query;
        return UriUtil.setQuery(uri, newQuery);
    }

    public static URI setQuery(URI uri, String query) {
        URI u = uri;
        try {
            u = new URI(u.getScheme(), u.getUserInfo(), u.getHost(), u.getPort(), u.getPath(), query, u.getFragment());
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(UriUtil.class.getName()).log(Level.WARNING, "Unexpected Exception " + ex.getMessage(), ex);
        }
        return u;
    }

    public static URI clearQuery(URI uri) {
        return UriUtil.setQuery(uri, null);
    }

    public static @NonNull Map<String, String> parseQuery(@NonNull URI uri) {
        String query = uri.getQuery();
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        if (query != null) {
            for (String pair : query.split("&")) {
                int p = pair.indexOf(61);
                String key = pair.substring(0, p);
                String value = pair.substring(p + 1);
                map.put(key, value);
            }
        }
        return map;
    }

    public static @NonNull URI relativize(@Nullable URI base, @NonNull URI uri) {
        URI relativized = uri;
        if (base == null) {
            return uri;
        }
        if ("file".equals(base.getScheme()) && ("file".equals(relativized.getScheme()) || relativized.getScheme() == null)) {
            Path other = Paths.get(relativized);
            Path relativizedPath = other.isAbsolute() ? Paths.get(base).relativize(other) : other;
            if (relativizedPath.isAbsolute()) {
                relativized = relativizedPath.toUri();
            } else {
                try {
                    relativized = new URI(null, null, relativizedPath.toString(), null, null);
                }
                catch (URISyntaxException e) {
                    relativized = base;
                }
            }
        } else {
            relativized = base.relativize(relativized);
        }
        return relativized;
    }

    public static @NonNull URI absolutize(@Nullable URI base, @NonNull URI uri) {
        if (base == null) {
            return uri;
        }
        URI absolutized = uri;
        if ("file".equals(base.getScheme()) && ("file".equals(absolutized.getScheme()) || absolutized.getScheme() == null)) {
            String pathStr = absolutized.getPath();
            if (pathStr.startsWith("/") && pathStr.indexOf(58) == 2) {
                pathStr = pathStr.substring(1);
            }
            absolutized = Paths.get(base).resolve(Paths.get(pathStr, new String[0])).normalize().toUri();
        } else {
            if ("jar".equals(base.getScheme()) && null == uri.getScheme()) {
                String baseStr = base.toString();
                String uriStr = uri.toString();
                try {
                    return new URI(baseStr + "/" + uriStr);
                }
                catch (URISyntaxException e) {
                    return uri;
                }
            }
            absolutized = base.resolve(absolutized);
        }
        return absolutized;
    }

    public static @NonNull URI getParent(@NonNull URI uri) {
        if ("jar".equals(uri.getScheme())) {
            try {
                String str = uri.toString();
                return new URI(str.substring(0, str.lastIndexOf(47)));
            }
            catch (URISyntaxException e) {
                return uri;
            }
        }
        return uri.resolve(".");
    }
}

