/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.base.converter;

import java.nio.CharBuffer;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.base.converter.Converter;

public class FormatConverterAdapter
extends Format {
    private static final long serialVersionUID = 1L;
    private final @NonNull Converter<Object> converter;

    public FormatConverterAdapter(Converter<?> converter) {
        Converter<?> temp = converter;
        this.converter = temp;
    }

    @Override
    public @NonNull StringBuffer format(Object obj, @NonNull StringBuffer toAppendTo, @NonNull FieldPosition pos) {
        toAppendTo.append(this.converter.toString(obj));
        return toAppendTo;
    }

    @Override
    public @Nullable Object parseObject(@NonNull String source, @NonNull ParsePosition pos) {
        try {
            CharBuffer buf = CharBuffer.wrap(source);
            Object value = this.converter.fromString(buf, null);
            pos.setIndex(buf.position());
            return value;
        }
        catch (ParseException ex) {
            pos.setErrorIndex(ex.getErrorOffset());
            return null;
        }
    }
}

