/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.base.converter;

import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.nio.CharBuffer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.util.Locale;
import java.util.Objects;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.base.converter.Converter;
import org.jhotdraw8.base.converter.IdResolver;
import org.jhotdraw8.base.converter.IdSupplier;

public class NumberConverter
implements Converter<Number> {
    private final boolean allowsNullValue;
    private final @NonNull Number min;
    private final @NonNull Number max;
    private final @Nullable String unit;
    private final @NonNull DecimalFormat decimalFormat;
    private final @NonNull DecimalFormat scientificFormat;
    private final double factor;
    private final int minNegativeExponent = -3;
    private final int minPositiveExponent = 7;
    private final boolean usesScientificNotation = true;
    private final @NonNull Class<? extends Number> valueClass;

    public NumberConverter() {
        this(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 1.0);
    }

    public NumberConverter(Class<? extends Number> valueClass) {
        this(valueClass, null, null, 1.0, false, null);
    }

    public NumberConverter(double min, double max, double multiplier) {
        this(Double.class, min, max, multiplier, false, null);
    }

    public NumberConverter(double min, double max, double multiplier, boolean allowsNullValue) {
        this(Double.class, min, max, multiplier, allowsNullValue, null);
    }

    public NumberConverter(Class<? extends Number> valueClass, Number min, Number max, double multiplier, boolean allowsNullValue, String unit) {
        this(valueClass, min, max, multiplier, allowsNullValue, unit, valueClass == Float.class ? new DecimalFormat("#################0.########", new DecimalFormatSymbols(Locale.ENGLISH)) : new DecimalFormat("#################0.#################", new DecimalFormatSymbols(Locale.ENGLISH)), new DecimalFormat("0.0################E0", new DecimalFormatSymbols(Locale.ENGLISH)));
    }

    public NumberConverter(@NonNull Class<? extends Number> valueClass, @NonNull Number min, @NonNull Number max, double multiplier, boolean allowsNullValue, @Nullable String unit, @NonNull DecimalFormat decimalFormat, @NonNull DecimalFormat scientificFormat) {
        this.valueClass = valueClass;
        this.decimalFormat = decimalFormat;
        this.scientificFormat = scientificFormat;
        this.min = min;
        this.max = max;
        this.factor = multiplier;
        this.allowsNullValue = allowsNullValue;
        this.unit = unit;
    }

    public NumberConverter(double min, double max, double multiplier, boolean allowsNullValue, String unit) {
        this(Double.class, min, max, multiplier, allowsNullValue, unit);
    }

    public @NonNull Number getMinimum() {
        return this.min;
    }

    public @NonNull Number getMaximum() {
        return this.max;
    }

    public double getFactor() {
        return this.factor;
    }

    public boolean getAllowsNullValue() {
        return this.allowsNullValue;
    }

    @Override
    public void toString(@NonNull Appendable buf, @Nullable IdSupplier idSupplier, @Nullable Number value) throws IOException {
        if (value == null) {
            buf.append(this.allowsNullValue ? "none" : "NaN");
            return;
        }
        Number number = value;
        Objects.requireNonNull(number);
        Number number2 = number;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Long.class, Integer.class, Byte.class, Short.class, Float.class}, (Object)number2, n)) {
            case 0: {
                Long l = (Long)number2;
                long v = l;
                if (this.factor != 1.0) {
                    v = (long)((double)v * this.factor);
                }
                buf.append(Long.toString(v));
                break;
            }
            case 1: {
                Integer i = (Integer)number2;
                int v = i;
                if (this.factor != 1.0) {
                    v = (int)((double)v * this.factor);
                }
                buf.append(Integer.toString(v));
                break;
            }
            case 2: {
                Byte b = (Byte)number2;
                byte v = b;
                if (this.factor != 1.0) {
                    v = (byte)((double)v * this.factor);
                }
                buf.append(Byte.toString(v));
                break;
            }
            case 3: {
                Short i = (Short)number2;
                short v = i;
                if (this.factor != 1.0) {
                    v = (short)((double)v * this.factor);
                }
                buf.append(Short.toString(v));
                break;
            }
            case 4: {
                String str;
                double exponent;
                Float aFloat = (Float)number2;
                float v = aFloat.floatValue();
                if (this.factor != 1.0) {
                    v = (float)((double)v * this.factor);
                }
                if (Float.isInfinite(v)) {
                    if ((double)v < 0.0) {
                        buf.append('-');
                    }
                    buf.append("INF");
                    break;
                }
                if (Float.isNaN(v)) {
                    buf.append("NaN");
                    break;
                }
                double d = exponent = v == 0.0f ? 0.0 : Math.log10(Math.abs(v));
                if (exponent > -3.0 && exponent < 7.0) {
                    str = Float.toString(v);
                    int exponentIndex = str.indexOf(69);
                    int pointIndex = str.indexOf(46);
                    int fractionDigits = (exponentIndex == -1 ? str.length() : exponentIndex) - pointIndex;
                    if (str.endsWith(".0")) {
                        str = str.substring(0, str.length() - 2);
                    }
                    if (exponentIndex >= 0 || fractionDigits > this.decimalFormat.getMaximumFractionDigits()) {
                        str = this.decimalFormat.format(v);
                    }
                } else {
                    str = this.scientificFormat.format(v);
                }
                buf.append(str);
                break;
            }
            default: {
                double v = value.doubleValue();
                if (this.factor != 1.0) {
                    v *= this.factor;
                }
                if (Double.isInfinite(v)) {
                    if (v < 0.0) {
                        buf.append('-');
                    }
                    buf.append("INF");
                    break;
                }
                if (Double.isNaN(v)) {
                    buf.append("NaN");
                    break;
                }
                double exponent = v == 0.0 ? 1.0 : Math.log10(Math.abs(v));
                String str = exponent > -3.0 && exponent < 7.0 ? this.decimalFormat.format(v) : this.scientificFormat.format(v);
                buf.append(str);
            }
        }
        if (value != null && this.unit != null) {
            buf.append(this.unit);
        }
    }

    @Override
    public @Nullable Number fromString(@NonNull CharBuffer str, @Nullable IdResolver idResolver) throws ParseException {
        Number value;
        String text;
        int end;
        if (str.isEmpty() && this.getAllowsNullValue()) {
            return null;
        }
        int remaining = str.remaining();
        boolean noMoreSigns = false;
        boolean noMorePoints = false;
        int noMoreEs = 0;
        block21: for (end = 0; end < remaining; ++end) {
            char c = str.charAt(end);
            switch (c) {
                case '+': 
                case '-': {
                    if (noMoreSigns) break block21;
                    noMoreSigns = true;
                    continue block21;
                }
                case '.': {
                    if (noMorePoints) break block21;
                    noMoreSigns = true;
                    noMorePoints = true;
                    continue block21;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    noMoreSigns = true;
                    continue block21;
                }
                case 'E': 
                case 'e': {
                    if (noMoreEs != 0) break block21;
                    noMoreSigns = false;
                    noMorePoints = false;
                    noMoreEs = 1;
                    continue block21;
                }
                case 'I': 
                case 'N': {
                    end += 3;
                    break block21;
                }
            }
        }
        switch (text = str.subSequence(0, end).toString()) {
            case "-INF": {
                str.position(str.position() + end);
                return Double.NEGATIVE_INFINITY;
            }
            case "INF": {
                str.position(str.position() + end);
                return Double.POSITIVE_INFINITY;
            }
            case "NaN": {
                str.position(str.position() + end);
                return Double.NaN;
            }
        }
        if (this.unit != null && end + this.unit.length() <= str.length() && str.subSequence(end, end + this.unit.length()).toString().startsWith(this.unit)) {
            end += this.unit.length();
        }
        if (text.isEmpty()) {
            throw new ParseException("Could not convert the string=\"" + String.valueOf(str) + "\" to a numeric value.", str.position());
        }
        Class<? extends Number> valueClass = this.getValueClass();
        if (valueClass != null) {
            try {
                if (valueClass == Integer.class) {
                    int n;
                    int n2 = Integer.parseInt(text);
                    if (this.factor != 1.0) {
                        n = (int)((double)n2 / this.factor);
                    }
                    value = n;
                }
                if (valueClass == Long.class) {
                    long l = Long.parseLong(text);
                    if (this.factor != 1.0) {
                        l = (long)((double)l / this.factor);
                    }
                    value = l;
                }
                if (valueClass == Float.class) {
                    float f = Float.parseFloat(text);
                    if (this.factor != 1.0) {
                        f = (float)((double)f / this.factor);
                    }
                    value = Float.valueOf(f);
                }
                if (valueClass == Double.class) {
                    double d = Double.parseDouble(text);
                    if (this.factor != 1.0) {
                        d /= this.factor;
                    }
                    value = d;
                }
                if (valueClass == Byte.class) {
                    byte by;
                    byte by2 = Byte.parseByte(text);
                    if (this.factor != 1.0) {
                        by = (byte)((double)by2 / this.factor);
                    }
                    value = by;
                }
                if (valueClass == Short.class) {
                    short s;
                    short s2 = Short.parseShort(text);
                    if (this.factor != 1.0) {
                        s = (short)((double)s2 / this.factor);
                    }
                    value = s;
                }
                throw new ParseException("Could not convert the string=\"" + String.valueOf(str) + "\" to a numeric value.", str.position());
            }
            catch (NumberFormatException numberFormatException) {
                ParseException pe = new ParseException("Could not convert the string=\"" + String.valueOf(str) + "\" to a numeric value.", str.position());
                pe.initCause(numberFormatException);
                throw pe;
            }
        } else {
            throw new ParseException("Could not convert the string=\"" + String.valueOf(str) + "\" to a numeric value of class=\"" + String.valueOf(valueClass) + "\".", str.position());
        }
        try {
            if (!this.isValidValue(value, true)) {
                throw new ParseException("Could not convert the string=\"" + String.valueOf(str) + "\" to a numeric value.", str.position());
            }
        }
        catch (ClassCastException classCastException) {
            ParseException pe = new ParseException("Could not convert the string=\"" + String.valueOf(str) + "\" to a numeric value.", str.position());
            pe.initCause(classCastException);
            throw pe;
        }
        str.position(str.position() + end);
        return value;
    }

    private boolean isValidValue(@NonNull Number value, boolean wantsCCE) {
        try {
            if (((Comparable)((Object)this.min)).compareTo(value) > 0) {
                return false;
            }
        }
        catch (ClassCastException cce) {
            if (wantsCCE) {
                throw cce;
            }
            return false;
        }
        try {
            if (((Comparable)((Object)this.max)).compareTo(value) < 0) {
                return false;
            }
        }
        catch (ClassCastException cce) {
            if (wantsCCE) {
                throw cce;
            }
            return false;
        }
        return true;
    }

    public int getMinimumNegativeExponent() {
        return -3;
    }

    public int getMinimumPositiveExponent() {
        return 7;
    }

    public boolean isUsesScientificNotation() {
        return true;
    }

    public @NonNull Class<? extends Number> getValueClass() {
        return this.valueClass;
    }

    @Override
    public @Nullable Number getDefaultValue() {
        return 0.0;
    }
}

