/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.base.io;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.PrimitiveIterator;
import java.util.Spliterators;
import java.util.function.IntPredicate;
import java.util.stream.IntStream;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.base.io.ListHelper;

class IntArrayList
extends AbstractList<Integer> {
    private static final int[] EMPTY = new int[0];
    private int[] items;
    private int size;

    public IntArrayList() {
        this.items = EMPTY;
    }

    public IntArrayList(int initialCapacity) {
        this.items = new int[initialCapacity];
    }

    public IntArrayList(@NonNull Collection<Integer> collection) {
        this.size = collection.size();
        this.items = new int[this.size];
        int count = 0;
        for (Integer value : collection) {
            this.items[count++] = value;
        }
    }

    private IntArrayList(int @NonNull [] items) {
        this.items = items;
        this.size = items.length;
    }

    public static @NonNull IntArrayList of(int ... items) {
        return new IntArrayList(items);
    }

    public void addAsInt(int newItem) {
        this.grow(this.size + 1);
        this.items[this.size++] = newItem;
    }

    public void addAsInt(int index, int newItem) {
        Objects.checkIndex(index, this.size + 1);
        this.grow(this.size + 1);
        this.items[index] = newItem;
        ++this.size;
    }

    public void addAllAsInt(@NonNull IntArrayList that) {
        if (that.isEmpty()) {
            return;
        }
        this.grow(this.size + that.size);
        System.arraycopy(that.items, 0, this.items, this.size, that.size);
        this.size += that.size;
    }

    public <T extends Collection<Integer>> @NonNull T addAllInto(@NonNull T out) {
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            out.add(this.items[i]);
        }
        return out;
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    public void copyInto(int @NonNull [] a, int offset) {
        System.arraycopy(this.items, 0, a, offset, this.size);
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IntArrayList other = (IntArrayList)obj;
        if (other.size != this.size) {
            return false;
        }
        for (int i = 0; i < this.size; ++i) {
            if (other.items[i] == this.items[i]) continue;
            return false;
        }
        return true;
    }

    public int getAsInt(int index) {
        Objects.checkIndex(index, this.size);
        return this.items[index];
    }

    @Override
    public Integer get(int index) {
        Objects.checkIndex(index, this.size);
        return this.items[index];
    }

    public int getLastAsInt() {
        return this.getAsInt(this.size - 1);
    }

    public int getFirstAsInt() {
        return this.getAsInt(0);
    }

    public void setSize(int newSize) {
        this.grow(newSize);
        if (newSize > this.size) {
            Arrays.fill(this.items, this.size, newSize, 0);
        }
        this.size = newSize;
    }

    @Override
    public int hashCode() {
        int result = 1;
        for (int i = 0; i < this.size; ++i) {
            result = 31 * result + this.items[i];
        }
        return result;
    }

    private void grow(int capacity) {
        if (this.items.length < capacity) {
            this.items = ListHelper.grow(Math.max(1, this.items.length * 2), 1, this.items);
        }
    }

    public int indexOfAsInt(int item) {
        return this.indexOfAsInt(item, 0);
    }

    public int indexOfAsInt(int item, int start) {
        for (int i = start; i < this.size; ++i) {
            if (this.items[i] != item) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOfAsInt(int item) {
        return this.lastIndexOfAsInt(item, this.size - 1);
    }

    public int lastIndexOfAsInt(int item, int start) {
        for (int i = start; i >= 0; --i) {
            if (this.items[i] != item) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof Integer) {
            int e = (Integer)o;
            return this.indexOfAsInt(e) != -1;
        }
        return false;
    }

    public int removeAtAsInt(int index) {
        Objects.checkIndex(index, this.size);
        int removedItem = this.items[index];
        int numMoved = this.size - index - 1;
        if (numMoved > 0) {
            System.arraycopy(this.items, index + 1, this.items, index, numMoved);
        }
        --this.size;
        return removedItem;
    }

    public int removeLastAsInt() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.removeAtAsInt(this.size - 1);
    }

    public int setAsInt(int index, int newItem) {
        Objects.checkIndex(index, this.size);
        int removedItem = this.items[index];
        this.items[index] = newItem;
        return removedItem;
    }

    @Override
    public int size() {
        return this.size;
    }

    public void trimToSize() {
        this.items = ListHelper.trimToSize(this.size, 1, this.items);
    }

    public  @NonNull PrimitiveIterator.OfInt iterator() {
        return new PrimitiveIterator.OfInt(){
            private int index = 0;
            private final int size;
            private final int[] items;
            {
                this.size = IntArrayList.this.size;
                this.items = IntArrayList.this.items;
            }

            @Override
            public int nextInt() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.items[this.index++];
            }

            @Override
            public boolean hasNext() {
                return this.index < this.size;
            }
        };
    }

    public  @NonNull Spliterator.OfInt spliterator() {
        return Spliterators.spliterator(this.items, 0, this.size, 1040);
    }

    public @NonNull IntStream intStream() {
        return this.size == 0 ? IntStream.empty() : Arrays.stream(this.items, 0, this.size);
    }

    public int @NonNull [] toIntArray() {
        int[] result = new int[this.size];
        System.arraycopy(this.items, 0, result, 0, this.size);
        return result;
    }

    @Override
    public boolean add(Integer integer) {
        this.addAsInt(integer);
        return true;
    }

    @Override
    public boolean remove(Object o) {
        int index;
        if (o instanceof Integer && (index = this.indexOfAsInt((Integer)o)) != -1) {
            this.removeAtAsInt(index);
            return true;
        }
        return false;
    }

    @Override
    public @NonNull String toString() {
        StringBuilder b = new StringBuilder();
        b.append('[');
        for (int i = 0; i < this.size; ++i) {
            if (i > 0) {
                b.append(", ");
            }
            b.append(this.items[i]);
        }
        return b.append(']').toString();
    }

    public void sort() {
        Arrays.sort(this.items, 0, this.size);
    }

    public boolean removeIfAsInt(@NonNull IntPredicate filter) {
        boolean hasRemoved = false;
        Objects.requireNonNull(filter, "filter");
        for (int i = this.size - 1; i >= 0; --i) {
            if (!filter.test(this.getAsInt(i))) continue;
            this.removeAtAsInt(i);
            hasRemoved = true;
        }
        return hasRemoved;
    }

    @Override
    public void sort(@Nullable Comparator<? super Integer> c) {
        if (this.size > 1) {
            if (c == null) {
                Arrays.sort(this.items, 0, this.size);
            } else {
                int i;
                Integer[] objects = new Integer[this.size];
                for (i = 0; i < this.size; ++i) {
                    objects[i] = this.items[i];
                }
                Arrays.sort(objects, 0, this.size, c);
                for (i = 0; i < this.size; ++i) {
                    this.items[i] = objects[i];
                }
            }
        }
    }
}

