/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.base.text;

import java.text.CollationKey;
import java.text.Collator;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.jhotdraw8.annotation.Nullable;

public class CachingCollator
implements Comparator<String> {
    private final Collator collator;
    private final Map<String, CollationKey> keyMap = new HashMap<String, CollationKey>();

    public CachingCollator(Collator collator) {
        this.collator = collator;
    }

    @Override
    public int compare(@Nullable String o1, @Nullable String o2) {
        CollationKey k1 = this.keyMap.computeIfAbsent(o1 == null ? "" : o1, this.collator::getCollationKey);
        CollationKey k2 = this.keyMap.computeIfAbsent(o2 == null ? "" : o2, this.collator::getCollationKey);
        return k1.compareTo(k2);
    }

    public void clearCache() {
        this.keyMap.clear();
    }
}

