/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.base.text;

import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;

public class RegexReplace {
    private final @Nullable String find;
    private final @Nullable String replace;
    private transient Pattern pattern;

    public RegexReplace() {
        this(null, null);
    }

    public RegexReplace(@Nullable String find, @Nullable String replace) {
        this.find = find;
        this.replace = replace;
    }

    public @Nullable String getFind() {
        return this.find;
    }

    public @Nullable String getReplace() {
        return this.replace;
    }

    public @NonNull String toString() {
        return "/" + this.escape(this.find) + "/" + this.escape(this.replace) + "/";
    }

    private @NonNull String escape(@Nullable String str) {
        return str == null ? "" : str.replace("/", "\\/");
    }

    public @Nullable String apply(@Nullable String str) {
        if (str == null) {
            return null;
        }
        if (this.find == null) {
            return this.replace == null ? str : this.replace;
        }
        if (this.pattern == null) {
            this.pattern = Pattern.compile(this.find);
        }
        Matcher m = this.pattern.matcher(str);
        try {
            return this.replace == null ? m.replaceAll("$0") : m.replaceAll(this.replace);
        }
        catch (IndexOutOfBoundsException e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Unexpected Exception " + e.getMessage(), e);
            return str;
        }
    }

    public int hashCode() {
        int hash = 5;
        hash = 53 * hash + Objects.hashCode(this.find);
        hash = 53 * hash + Objects.hashCode(this.replace);
        return hash;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RegexReplace other = (RegexReplace)obj;
        if (!Objects.equals(this.find, other.find)) {
            return false;
        }
        return Objects.equals(this.replace, other.replace);
    }
}

