/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.base.converter;

import java.io.IOException;
import java.nio.CharBuffer;
import java.text.ParseException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jhotdraw8.base.converter.Converter;
import org.jhotdraw8.base.converter.IdResolver;
import org.jhotdraw8.base.converter.IdSupplier;
import org.jspecify.annotations.Nullable;

public class CaseInsensitiveMappedConverter<E>
implements Converter<E> {
    private final Map<String, E> fromStringMap = new LinkedHashMap<String, E>();
    private final Map<E, String> toStringMap = new LinkedHashMap<E, String>();

    public CaseInsensitiveMappedConverter(Map<String, E> fromStringMap) {
        for (Map.Entry<String, E> entry : fromStringMap.entrySet()) {
            this.fromStringMap.putIfAbsent(entry.getKey().toLowerCase(), entry.getValue());
            this.toStringMap.putIfAbsent(entry.getValue(), entry.getKey());
        }
    }

    @Override
    public @Nullable E fromString(CharBuffer in, @Nullable IdResolver idResolver) throws ParseException {
        String str = in.toString();
        in.position(in.length());
        E e = this.fromStringMap.get(str.toLowerCase());
        if (e == null) {
            throw new ParseException("Could not find string=\"" + str + "\" in the set " + String.valueOf(this.fromStringMap.keySet()) + ".", 0);
        }
        return e;
    }

    @Override
    public @Nullable E getDefaultValue() {
        return null;
    }

    @Override
    public <TT extends E> void toString(Appendable out, @Nullable IdSupplier idSupplier, @Nullable TT value) throws IOException {
        if (value == null) {
            throw new IOException("Could not generate a string for value=null.");
        }
        String s = this.toStringMap.get(value);
        if (s == null) {
            throw new IOException("Could not find value=\"" + String.valueOf(value) + "\" in the set " + String.valueOf(this.toStringMap.keySet()) + ".");
        }
        out.append(s);
    }
}

