/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.base.converter;

import java.nio.CharBuffer;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import org.jhotdraw8.base.converter.Converter;
import org.jhotdraw8.base.converter.IdFactory;
import org.jhotdraw8.base.converter.IdResolver;
import org.jhotdraw8.base.converter.IdSupplier;
import org.jspecify.annotations.Nullable;

public class ConverterFormatAdapter
implements Converter<Object> {
    private final Format format;

    public ConverterFormatAdapter(Format format) {
        this.format = format;
    }

    @Override
    public String toString(Object value) {
        return this.format.format(value);
    }

    public Object fromString(String string, IdFactory idFactory, ParsePosition pp) {
        Object value = this.format.parseObject(string, pp);
        return value;
    }

    @Override
    public void toString(Appendable out, @Nullable IdSupplier idSupplier, Object value) {
        throw new UnsupportedOperationException("Could not generate a string for value=\"" + String.valueOf(value) + "\"." + String.valueOf(this.format));
    }

    @Override
    public Object fromString(CharBuffer buf, @Nullable IdResolver idResolver) throws ParseException {
        int pos = buf.position();
        String str = buf.toString();
        ParsePosition pp = new ParsePosition(0);
        Object value = this.format.parseObject(str, pp);
        if (pp.getErrorIndex() != -1) {
            buf.position(pos + pp.getErrorIndex());
            throw new ParseException("Could not parse the string=\"" + str + "\".", buf.position());
        }
        buf.position(pos + pp.getIndex());
        return value;
    }

    @Override
    public @Nullable Object getDefaultValue() {
        return null;
    }
}

