/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.base.converter;

import java.io.IOException;
import java.nio.CharBuffer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.util.Locale;
import org.jhotdraw8.base.converter.Converter;
import org.jhotdraw8.base.converter.IdResolver;
import org.jhotdraw8.base.converter.IdSupplier;
import org.jspecify.annotations.Nullable;

public class FloatConverter
implements Converter<Float> {
    private final boolean nullable;
    private final boolean usesScientificNotation = true;
    private final DecimalFormat decimalFormat = new DecimalFormat("#################0.#######", new DecimalFormatSymbols(Locale.ENGLISH));
    private final DecimalFormat scientificFormat = new DecimalFormat("0.0########E0", new DecimalFormatSymbols(Locale.ENGLISH));
    private final int minNegativeExponent = -3;
    private final int minPositiveExponent = 7;

    public FloatConverter() {
        this(false);
    }

    public FloatConverter(boolean nullable) {
        this.nullable = nullable;
    }

    @Override
    public @Nullable Float fromString(CharBuffer in, @Nullable IdResolver idResolver) throws ParseException {
        String str = in.toString();
        try {
            if (in.isEmpty() && this.nullable) {
                return null;
            }
            float result = Float.parseFloat(str);
            in.position(in.length());
            return Float.valueOf(result);
        }
        catch (NumberFormatException e) {
            throw new ParseException("Could not parse a float value from string=\"" + str + "\".", 0);
        }
    }

    @Override
    public <TT extends Float> void toString(Appendable buf, @Nullable IdSupplier idSupplier, @Nullable TT value) throws IOException {
        if (value == null) {
            return;
        }
        float v = value.floatValue();
        if (Float.isInfinite(v)) {
            if ((double)v < 0.0) {
                buf.append('-');
            }
            buf.append("Infinity");
        } else if (Float.isNaN(v)) {
            buf.append("NaN");
        } else {
            String str;
            double exponent;
            double d = exponent = v == 0.0f ? 0.0 : Math.log10(Math.abs(v));
            if (exponent > -3.0 && exponent < 7.0) {
                str = Float.toString(v);
                int exponentIndex = str.indexOf(69);
                int pointIndex = str.indexOf(46);
                int fractionDigits = (exponentIndex == -1 ? str.length() : exponentIndex) - pointIndex;
                if (str.endsWith(".0")) {
                    str = str.substring(0, str.length() - 2);
                }
                if (exponentIndex >= 0 || fractionDigits > this.decimalFormat.getMaximumFractionDigits()) {
                    str = this.decimalFormat.format(v);
                }
            } else {
                str = this.scientificFormat.format(v);
            }
            buf.append(str);
        }
    }

    @Override
    public @Nullable Float getDefaultValue() {
        return Float.valueOf(0.0f);
    }
}

