/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.base.converter;

import java.io.IOException;
import java.nio.CharBuffer;
import java.text.ParseException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jhotdraw8.base.converter.Converter;
import org.jhotdraw8.base.converter.IdResolver;
import org.jhotdraw8.base.converter.IdSupplier;
import org.jspecify.annotations.Nullable;

public class MappedConverter<E>
implements Converter<E> {
    private final Map<String, E> fromStringMap = new LinkedHashMap<String, E>();
    private final Map<E, String> toStringMap = new LinkedHashMap<E, String>();
    private final String nullValue;

    public MappedConverter(Map<String, E> fromStringMap) {
        this(fromStringMap, false);
    }

    public MappedConverter(Map<String, E> fromStringMap, boolean nullable) {
        this(fromStringMap, nullable ? "none" : null);
    }

    public MappedConverter(Map<String, E> fromStringMap, String nullValue) {
        for (Map.Entry<String, E> entry : fromStringMap.entrySet()) {
            this.fromStringMap.putIfAbsent(entry.getKey(), entry.getValue());
            this.toStringMap.putIfAbsent(entry.getValue(), entry.getKey());
        }
        this.nullValue = nullValue;
    }

    @Override
    public @Nullable E fromString(CharBuffer in, @Nullable IdResolver idResolver) throws ParseException {
        String identifier = in.toString();
        in.position(in.length());
        if (this.nullValue != null && this.nullValue.equals(identifier)) {
            return null;
        }
        E e = this.fromStringMap.get(identifier);
        if (e == null) {
            throw new ParseException("Could not convert the string=\"" + identifier + "\" to a value.", 0);
        }
        return e;
    }

    @Override
    public @Nullable E getDefaultValue() {
        return null;
    }

    @Override
    public <TT extends E> void toString(Appendable out, @Nullable IdSupplier idSupplier, @Nullable TT value) throws IOException {
        String s;
        if (value == null) {
            if (this.nullValue != null) {
                throw new IOException("Could not convert the value=null to a non-null string.");
            }
            out.append(null);
        }
        if ((s = this.toStringMap.get(value)) == null) {
            throw new IOException("Could not convert the value=\"" + String.valueOf(value) + "\" to a string.");
        }
        out.append(s);
    }
}

