/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.base.converter;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.jhotdraw8.base.converter.IdFactory;
import org.jhotdraw8.base.converter.SimpleUriResolver;
import org.jhotdraw8.base.converter.UriResolver;
import org.jspecify.annotations.Nullable;

public class SimpleIdFactory
implements IdFactory {
    private final Map<String, Long> prefixToNextId = new HashMap<String, Long>(128, 0.4f);
    private final Map<String, Object> idToObject = new HashMap<String, Object>(128, 0.4f);
    private final Map<Object, String> objectToId = new HashMap<Object, String>(128, 0.4f);
    private UriResolver uriResolver = new SimpleUriResolver();
    private @Nullable URI documentHome;

    @Override
    public void reset() {
        this.prefixToNextId.clear();
        this.idToObject.clear();
        this.objectToId.clear();
    }

    @Override
    public @Nullable String createId(Object object) {
        return this.createId(object, "");
    }

    @Override
    public String getId(Object object) {
        return this.objectToId.get(object);
    }

    @Override
    public void setDocumentHome(@Nullable URI documentHome) {
        this.documentHome = documentHome;
    }

    @Override
    public URI relativize(URI uri) {
        return this.documentHome == null ? uri : this.uriResolver.relativize(this.documentHome, uri);
    }

    @Override
    public Object getObject(String id) {
        return this.idToObject.get(id);
    }

    @Override
    public URI absolutize(URI uri) {
        return this.documentHome == null ? uri : this.uriResolver.absolutize(this.documentHome, uri);
    }

    @Override
    public Object putIdAndObject(String id, Object object) {
        Object oldObject;
        String oldId = this.objectToId.put(object, id);
        if (oldId != null) {
            this.idToObject.remove(oldId);
        }
        if ((oldObject = this.idToObject.put(id, object)) != null) {
            this.objectToId.remove(oldObject);
        }
        return oldObject;
    }

    @Override
    public Object putIdToObject(String id, Object object) {
        Object oldObject = this.idToObject.put(id, object);
        if (oldObject != null) {
            this.objectToId.remove(oldObject);
        }
        return oldObject;
    }

    @Override
    public String createId(Object object, @Nullable String prefix) {
        Object id = this.objectToId.get(object);
        if (id == null) {
            long pNextId = this.prefixToNextId.getOrDefault(prefix, 1L);
            while (this.idToObject.containsKey(id = (prefix == null ? "" : prefix) + pNextId++)) {
            }
            this.objectToId.put(object, (String)id);
            this.idToObject.put((String)id, object);
            this.prefixToNextId.put(prefix, pNextId);
        }
        return id;
    }

    @Override
    public @Nullable String createId(Object object, @Nullable String prefix, @Nullable String suggestedId) {
        Object existingId = this.objectToId.get(object);
        if (existingId == null) {
            if (suggestedId != null && !this.idToObject.containsKey(suggestedId)) {
                existingId = suggestedId;
            } else {
                long pNextId = this.prefixToNextId.getOrDefault(prefix, 1L);
                while (this.idToObject.containsKey(existingId = (prefix == null ? "" : prefix) + pNextId++)) {
                }
                this.prefixToNextId.put(prefix, pNextId);
            }
            this.objectToId.put(object, (String)existingId);
            this.idToObject.put((String)existingId, object);
        }
        return existingId;
    }

    public UriResolver getUriResolver() {
        return this.uriResolver;
    }

    public void setUriResolver(UriResolver uriResolver) {
        this.uriResolver = uriResolver;
    }
}

