/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.base.text;

import java.io.Serializable;
import java.text.CollationKey;
import java.text.Collator;
import java.text.ParseException;
import java.text.RuleBasedCollator;
import java.util.Comparator;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jspecify.annotations.Nullable;

public class NaturalSortCollator
extends Collator {
    private final Collator collator;

    public NaturalSortCollator() {
        this(Locale.getDefault());
    }

    public NaturalSortCollator(Locale locale) {
        Collator c = Collator.getInstance(locale);
        if (c instanceof RuleBasedCollator) {
            Object rules = ((RuleBasedCollator)c).getRules();
            int pos = ((String)rules).indexOf(",'-'");
            int primaryRelationPos = ((String)rules).indexOf(60);
            if (primaryRelationPos == ((String)rules).indexOf("'<'")) {
                primaryRelationPos = ((String)rules).indexOf(60, primaryRelationPos + 2);
            }
            if (pos != -1 && pos < primaryRelationPos) {
                rules = ((String)rules).substring(0, pos) + ((String)rules).substring(pos + 4, primaryRelationPos) + "<'-'" + ((String)rules).substring(primaryRelationPos);
            }
            pos = ((String)rules).indexOf(";' '");
            primaryRelationPos = ((String)rules).indexOf(60);
            if (primaryRelationPos == ((String)rules).indexOf("'<'")) {
                primaryRelationPos = ((String)rules).indexOf(60, primaryRelationPos + 2);
            }
            if (pos != -1 && pos < primaryRelationPos) {
                rules = ((String)rules).substring(0, pos) + ((String)rules).substring(pos + 4, primaryRelationPos) + "<' '" + ((String)rules).substring(primaryRelationPos);
            }
            try {
                c = new RuleBasedCollator((String)rules);
            }
            catch (ParseException e) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Unexpected Exception " + e.getMessage(), e);
            }
        }
        this.collator = c;
    }

    public static <T> Comparator<T> comparing(Function<? super T, String> keyExtractor) {
        NaturalSortCollator collator = new NaturalSortCollator();
        Objects.requireNonNull(keyExtractor, "keyExtractor");
        return (Comparator & Serializable)(c1, c2) -> collator.compare((String)keyExtractor.apply(c1), (String)keyExtractor.apply(c2));
    }

    private void appendDigitGroup(StringBuilder out, String s, int start, int end) {
        assert (start < end) : "start:" + start + " end:" + end;
        int num = Math.min(100, end - start) - 1;
        out.append((char)(num / 10 + 48));
        out.append((char)(num % 10 + 48));
        for (int j = start; j < end; ++j) {
            out.append(s.charAt(j));
        }
    }

    @Override
    public int compare(@Nullable String source, @Nullable String target) {
        if (source == null) {
            return target == null ? 0 : 1;
        }
        if (target == null) {
            return -1;
        }
        return this.collator.compare(this.expandNumbers(source), this.expandNumbers(target));
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (o instanceof NaturalSortCollator) {
            NaturalSortCollator that = (NaturalSortCollator)o;
            return this.collator.equals(that.collator);
        }
        return false;
    }

    @Nullable String expandNumbers(@Nullable String s) {
        if (s == null) {
            return null;
        }
        StringBuilder out = new StringBuilder();
        int n = s.length();
        int start = -1;
        for (int i = 0; i < n; ++i) {
            char ch = s.charAt(i);
            if ('0' <= ch && ch <= '9') {
                if (start >= 0) continue;
                start = i;
                continue;
            }
            if (start != -1) {
                this.appendDigitGroup(out, s, start, i);
                start = -1;
            }
            out.append(ch);
        }
        if (start != -1) {
            this.appendDigitGroup(out, s, start, n);
        }
        return out.toString();
    }

    @Override
    public CollationKey getCollationKey(String source) {
        return this.collator.getCollationKey(this.expandNumbers(source));
    }

    @Override
    public int hashCode() {
        return this.collator.hashCode();
    }
}

