/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.collection.computed;

import java.util.Objects;
import java.util.function.LongFunction;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.icollection.exception.SizeLimitExceededException;
import org.jhotdraw8.icollection.readonly.AbstractReadOnlyList;

public class ComputedList<E>
extends AbstractReadOnlyList<E> {
    private final boolean descending;
    private final long size;
    private final long from;
    private final long to;
    private final LongFunction<E> function;

    public ComputedList(long size, LongFunction<E> function) {
        this(size, function, false);
    }

    public ComputedList(long size, LongFunction<E> function, boolean descending) {
        this(0L, size, function, descending);
    }

    public ComputedList(long from, long to, LongFunction<E> function) {
        this(from, to, function, false);
    }

    public ComputedList(long from, long to, LongFunction<E> function, boolean descending) {
        this.function = function;
        this.descending = descending;
        this.from = from;
        this.to = to;
        try {
            this.size = Math.abs(Math.subtractExact(from, to));
        }
        catch (ArithmeticException e) {
            throw new SizeLimitExceededException("from=" + from + " to=" + to, (Throwable)e);
        }
    }

    public int size() {
        return this.size > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.size;
    }

    public long sizeAsLong() {
        return this.size;
    }

    public E get(int index) {
        Objects.checkIndex(index, this.size());
        return this.function.apply(this.offset(index));
    }

    private long offset(int index) {
        return this.descending ? this.to - (long)index - 1L : this.from + (long)index;
    }

    public @NonNull ComputedList<E> readOnlySubList(int fromIndex, int toIndex) {
        Objects.checkFromToIndex((long)fromIndex, (long)toIndex, this.size);
        return new ComputedList<E>(this.offset(fromIndex), this.offset(toIndex), this.function, this.descending);
    }

    public @NonNull ComputedList<E> readOnlyReversed() {
        return new ComputedList<E>(this.from, this.to, this.function, !this.descending);
    }
}

