/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.collection.enumerator;

import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.collection.enumerator.AbstractIntEnumerator;
import org.jhotdraw8.collection.function.IntToIntFunction;

public class IntRangeEnumerator
extends AbstractIntEnumerator {
    private int next;
    private final int to;
    private final @NonNull IntToIntFunction f;

    public IntRangeEnumerator(int endExclusive) {
        this(i -> i, 0, endExclusive);
    }

    public IntRangeEnumerator(int startInclusive, int endExclusive) {
        this(i -> i, startInclusive, endExclusive);
    }

    public IntRangeEnumerator(@NonNull IntToIntFunction f, int startInclusive, int endExclusive) {
        super(endExclusive - startInclusive, 16721);
        this.f = f;
        this.next = startInclusive;
        this.to = endExclusive;
    }

    @Override
    public long estimateSize() {
        return this.to - this.next;
    }

    @Override
    public boolean moveNext() {
        if (this.next < this.to) {
            this.current = this.f.applyAsInt(this.next);
            ++this.next;
            return true;
        }
        return false;
    }

    @Override
    public @Nullable IntRangeEnumerator trySplit() {
        IntRangeEnumerator intRangeEnumerator;
        int lo = this.next;
        int mid = lo + this.to >>> 1;
        if (lo >= mid) {
            intRangeEnumerator = null;
        } else {
            this.next = mid;
            IntRangeEnumerator intRangeEnumerator2 = new IntRangeEnumerator(this.f, lo, this.next);
            intRangeEnumerator = intRangeEnumerator2;
        }
        return intRangeEnumerator;
    }
}

