/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.collection.mapped;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;

public final class MappedSet<E, F>
extends AbstractSet<E> {
    private final Set<F> backingSet;
    private final Function<F, E> mapf;

    public MappedSet(Set<F> backingSet, Function<F, E> mapf) {
        this.backingSet = backingSet;
        this.mapf = mapf;
    }

    @Override
    public boolean contains(Object o) {
        return this.backingSet.contains(o);
    }

    @Override
    public @NonNull Iterator<E> iterator() {
        return new Iterator<E>(){
            private final Iterator<F> i;
            {
                this.i = MappedSet.this.backingSet.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.i.hasNext();
            }

            @Override
            public E next() {
                return MappedSet.this.mapf.apply(this.i.next());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public @NonNull Spliterator<E> spliterator() {
        class MappingSpliterator
        implements Spliterator<E> {
            private final Spliterator<F> i;

            public MappingSpliterator(Spliterator<F> i) {
                this.i = i;
            }

            @Override
            public boolean tryAdvance(@NonNull Consumer<? super E> action) {
                return this.i.tryAdvance((? super T f) -> action.accept((Object)MappedSet.this.mapf.apply(f)));
            }

            @Override
            public @Nullable Spliterator<E> trySplit() {
                Spliterator fSpliterator = this.i.trySplit();
                return fSpliterator == null ? null : new MappingSpliterator(fSpliterator);
            }

            @Override
            public long estimateSize() {
                return this.i.estimateSize();
            }

            @Override
            public int characteristics() {
                return this.i.characteristics();
            }
        }
        return new MappingSpliterator(this.backingSet.spliterator());
    }

    @Override
    public int size() {
        return this.backingSet.size();
    }
}

