/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.collection.pair;

import java.util.Objects;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;

public interface OrderedPair<U, V> {
    public U first();

    public V second();

    public static <U, V> boolean orderedPairEquals(@NonNull OrderedPair<U, V> pair, @Nullable Object obj) {
        if (pair == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (pair.getClass() != obj.getClass()) {
            return false;
        }
        OrderedPair other = (OrderedPair)obj;
        if (!Objects.equals(pair.first(), other.first())) {
            return false;
        }
        return Objects.equals(pair.second(), other.second());
    }

    public static <U, V> int orderedPairHashCode(@NonNull OrderedPair<U, V> pair) {
        int hash = 3;
        hash = 59 * hash + Objects.hashCode(pair.first());
        return (hash = 59 * hash + Objects.hashCode(pair.second())) == 0 ? -89 : hash;
    }
}

