/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.collection.pair;

import java.util.Objects;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;

public interface UnorderedPair<V> {
    default public V getOther(V someone) {
        V either = this.either();
        return Objects.equals(either, someone) ? this.other() : either;
    }

    public V either();

    public V other();

    public static <V> boolean unorderedPairEquals(@NonNull UnorderedPair<V> pair, @Nullable Object obj) {
        if (pair == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (pair.getClass() != obj.getClass()) {
            return false;
        }
        UnorderedPair other = (UnorderedPair)obj;
        if (Objects.equals(pair.either(), other.either()) && Objects.equals(pair.other(), other.other())) {
            return true;
        }
        return Objects.equals(pair.other(), other.either()) && Objects.equals(pair.either(), other.other());
    }

    public static <V> int unorderedPairHashCode(@NonNull UnorderedPair<V> pair) {
        int hash = 7 + Objects.hashCode(pair.either()) + Objects.hashCode(pair.other());
        return hash == 0 ? -61 : hash;
    }
}

