/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.collection.primitive;

import java.util.Comparator;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.collection.primitive.ByteConsumer;
import org.jhotdraw8.collection.primitive.SpliteratorOfByte;

public class ByteArraySpliterator
implements SpliteratorOfByte {
    private final byte[] array;
    private int index;
    private final int fence;
    private final int characteristics;

    public ByteArraySpliterator(byte[] array, int additionalCharacteristics) {
        this(array, 0, array.length, additionalCharacteristics);
    }

    public ByteArraySpliterator(byte[] array, int origin, int fence, int additionalCharacteristics) {
        this.array = array;
        this.index = origin;
        this.fence = fence;
        this.characteristics = additionalCharacteristics | 0x40 | 0x4000;
    }

    @Override
    public @Nullable SpliteratorOfByte trySplit() {
        ByteArraySpliterator byteArraySpliterator;
        int lo = this.index;
        int mid = lo + this.fence >>> 1;
        if (lo >= mid) {
            byteArraySpliterator = null;
        } else {
            this.index = mid;
            ByteArraySpliterator byteArraySpliterator2 = new ByteArraySpliterator(this.array, lo, this.index, this.characteristics);
            byteArraySpliterator = byteArraySpliterator2;
        }
        return byteArraySpliterator;
    }

    @Override
    public void forEachRemaining(@NonNull ByteConsumer action) {
        int i;
        if (action == null) {
            throw new NullPointerException();
        }
        byte[] a = this.array;
        int hi = this.fence;
        if (this.array.length >= hi && (i = this.index) >= 0 && i < (this.index = hi)) {
            do {
                action.accept(a[i]);
            } while (++i < hi);
        }
    }

    @Override
    public boolean tryAdvance(@NonNull ByteConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.index >= 0 && this.index < this.fence) {
            action.accept(this.array[this.index++]);
            return true;
        }
        return false;
    }

    @Override
    public long estimateSize() {
        return this.fence - this.index;
    }

    @Override
    public int characteristics() {
        return this.characteristics;
    }

    @Override
    public @Nullable Comparator<? super Byte> getComparator() {
        if (this.hasCharacteristics(4)) {
            return null;
        }
        throw new IllegalStateException();
    }
}

