/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.collection.primitive;

import java.util.Arrays;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.collection.primitive.IntSet;

public class DenseIntSet16Bit
implements IntSet {
    private char[] a;
    private char mark = '\u0001';

    public DenseIntSet16Bit() {
        this(0);
    }

    public DenseIntSet16Bit(int capacity) {
        this.a = new char[capacity];
    }

    @Override
    public boolean addAsInt(int element) {
        if (this.a[element] != this.mark) {
            this.a[element] = this.mark;
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAsInt(int element) {
        if (this.a[element] == this.mark) {
            this.a[element] = '\u0000';
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAsInt(int e) {
        return this.a[e] == this.mark;
    }

    @Override
    public void clear() {
        this.mark = (char)(this.mark + '\u0001');
        if (this.mark == '\u0000') {
            Arrays.fill(this.a, '\u0000');
            this.mark = '\u0001';
        }
    }

    public void setCapacity(int capacity) {
        this.a = Arrays.copyOf(this.a, capacity);
    }

    public int capacity() {
        return this.a.length;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DenseIntSet16Bit that = (DenseIntSet16Bit)o;
        return this.capacity() == that.capacity() && Arrays.equals(this.toLongArray(), that.toLongArray());
    }

    public int hashCode() {
        long h = 1234L;
        long[] words = this.toLongArray();
        int i = words.length;
        while (--i >= 0) {
            h ^= words[i] * (long)(i + 1);
        }
        return (int)(h >> 32 ^ h);
    }

    public long @NonNull [] toLongArray() {
        int length = (this.a.length - 1 >>> 6) + 1;
        long[] words = new long[length];
        int lastSetBit = -1;
        int n = this.capacity();
        for (int i = 0; i < n; ++i) {
            if (!this.containsAsInt(i)) continue;
            lastSetBit = i;
            int wordIndex = i >>> 6;
            int bitIndex = i & 0x3F;
            int n2 = wordIndex;
            words[n2] = words[n2] | 1L << bitIndex;
        }
        int usedLength = lastSetBit == -1 ? 0 : (lastSetBit >>> 6) + 1;
        return usedLength == length ? words : Arrays.copyOf(words, usedLength);
    }

    public @NonNull String toString() {
        int i;
        StringBuilder buf = new StringBuilder();
        buf.append('{');
        int n = this.capacity();
        for (i = 0; i < n; ++i) {
            if (!this.containsAsInt(i)) continue;
            buf.append(i++);
            break;
        }
        while (i < n) {
            if (this.containsAsInt(i)) {
                buf.append(", ");
                buf.append(i);
            }
            ++i;
        }
        buf.append('}');
        return buf.toString();
    }
}

