/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.collection.primitive;

import java.util.AbstractCollection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.collection.primitive.LongDeque;

public class LongArrayDeque
extends AbstractCollection<Long>
implements LongDeque {
    private long[] elements;
    private int head;
    private int tail;

    public LongArrayDeque() {
        this(8);
    }

    public LongArrayDeque(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("Capacity must be non-negative. capacity=" + capacity + ".");
        }
        int size = Integer.highestOneBit(capacity + capacity - 1);
        this.elements = new long[Math.max(size, 0)];
    }

    @Override
    public void addFirstAsLong(long e) {
        this.head = this.head - 1 & this.elements.length - 1;
        this.elements[this.head] = e;
        if (this.head == this.tail) {
            this.doubleCapacity();
        }
    }

    public void addFirstAsLongBranchless(long e, boolean reallyAdd) {
        this.head = this.head - 1 & this.elements.length - 1;
        this.elements[this.head] = e;
        if (this.head == this.tail) {
            this.doubleCapacity();
        }
    }

    public void addLastAllAsLong(long @NonNull [] array) {
        this.addLastAllAsLong(array, 0, array.length);
    }

    public void addLastAllAsLong(long @NonNull [] array, int offset, int length) {
        this.grow(length + this.size());
        int firstPart = this.elements.length - this.tail;
        if (this.tail >= this.head && firstPart >= length || this.head - this.tail > length) {
            System.arraycopy(array, offset, this.elements, this.tail, length);
            this.tail = this.tail + length & this.elements.length - 1;
            return;
        }
        System.arraycopy(array, offset, this.elements, this.tail, firstPart);
        int secondPart = length - firstPart;
        System.arraycopy(array, offset + firstPart, this.elements, 0, secondPart);
        this.tail = secondPart;
    }

    @Override
    public void addLastAsLong(long e) {
        this.elements[this.tail] = e;
        this.tail = this.tail + 1 & this.elements.length - 1;
        if (this.tail == this.head) {
            this.doubleCapacity();
        }
    }

    public void addLastAsLongBranchless(long e, boolean reallyAdd) {
        this.elements[this.tail] = e;
        if (reallyAdd) {
            this.tail = this.tail + 1 & this.elements.length - 1;
            if (this.tail == this.head) {
                this.doubleCapacity();
            }
        }
    }

    @Override
    public void clear() {
        this.tail = 0;
        this.head = 0;
    }

    @Override
    public @NonNull Iterator<Long> descendingIterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Long element() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.getFirstAsLong();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LongArrayDeque)) {
            return false;
        }
        LongArrayDeque that = (LongArrayDeque)o;
        if (this.size() != that.size()) {
            return false;
        }
        int thisMask = this.elements.length - 1;
        int thatMask = that.elements.length - 1;
        int i = this.head;
        int j = that.head;
        while (i != this.tail) {
            if (this.elements[i] != that.elements[j]) {
                return false;
            }
            i = i + 1 & thisMask;
            j = j + 1 & thatMask;
        }
        return true;
    }

    @Override
    public int firstIndexOfAsLong(long o) {
        if (this.tail < this.head) {
            int i;
            for (i = this.head; i < this.elements.length; ++i) {
                if (o != this.elements[i]) continue;
                return i - this.head;
            }
            for (i = 0; i < this.tail; ++i) {
                if (o != this.elements[i]) continue;
                return i + this.elements.length - this.head;
            }
        } else {
            for (int i = this.head; i < this.tail; ++i) {
                if (o != this.elements[i]) continue;
                return i - this.head;
            }
        }
        return -1;
    }

    @Override
    public long getFirstAsLong() {
        if (this.head == this.tail) {
            throw new NoSuchElementException();
        }
        return this.elements[this.head];
    }

    @Override
    public long getLastAsLong() {
        if (this.head == this.tail) {
            throw new NoSuchElementException();
        }
        return this.elements[this.tail == 0 ? this.elements.length - 1 : this.tail - 1];
    }

    private void doubleCapacity() {
        assert (this.head == this.tail);
        int size = this.elements.length;
        int r = size - this.head;
        long[] a = new long[size << 1];
        System.arraycopy(this.elements, this.head, a, 0, r);
        System.arraycopy(this.elements, 0, a, r, this.head);
        this.elements = a;
        this.head = 0;
        this.tail = size;
    }

    private void grow(int capacity) {
        if (this.elements.length > capacity) {
            return;
        }
        int newLength = Integer.highestOneBit(capacity + capacity - 1);
        long[] a = new long[newLength];
        int size = this.size();
        if (this.head < this.tail) {
            System.arraycopy(this.elements, this.head, a, 0, size);
        } else {
            int r = this.elements.length - this.head;
            System.arraycopy(this.elements, this.head, a, 0, r);
            System.arraycopy(this.elements, 0, a, r, this.head);
        }
        this.elements = a;
        this.head = 0;
        this.tail = size;
    }

    @Override
    public int hashCode() {
        int hash = 0;
        int mask = this.elements.length - 1;
        int i = this.head;
        while (i != this.tail) {
            hash = hash * 31 + (int)this.elements[i];
            i = i + 1 & mask;
        }
        return hash;
    }

    @Override
    public boolean isEmpty() {
        return this.head == this.tail;
    }

    @Override
    public @NonNull Iterator<Long> iterator() {
        return new DeqIterator();
    }

    @Override
    public int lastIndexOfAsLong(long o) {
        if (this.tail < this.head) {
            int i;
            for (i = this.elements.length - 1; i >= this.head; --i) {
                if (o != this.elements[i]) continue;
                return i - this.head;
            }
            for (i = this.tail - 1; i >= 0; --i) {
                if (o != this.elements[i]) continue;
                return i + this.elements.length - this.head;
            }
        } else {
            for (int i = this.tail - 1; i >= this.head; --i) {
                if (o != this.elements[i]) continue;
                return i - this.head;
            }
        }
        return -1;
    }

    public void removeAt(int i) {
        int size = this.size();
        Objects.checkIndex(i, size);
        if (this.tail < this.head) {
            if (this.head + i < this.elements.length) {
                if (i > 0) {
                    System.arraycopy(this.elements, this.head, this.elements, this.head + 1, i - 1);
                }
                this.elements[this.head] = 0L;
                this.head = this.head == this.elements.length ? 0 : this.head + 1;
            } else {
                if (i < size - 1) {
                    System.arraycopy(this.elements, i - this.elements.length + this.head + 1, this.elements, i - this.elements.length + this.head, size - i);
                }
                this.elements[this.tail] = 0L;
                this.tail = this.tail == 0 ? this.elements.length : this.tail - 1;
            }
        } else {
            if (i < size - 1) {
                System.arraycopy(this.elements, this.head + i + 1, this.elements, this.head + i, size - i);
            }
            this.elements[this.head + i] = 0L;
            --this.tail;
        }
    }

    @Override
    public long removeFirstAsLong() {
        if (this.head == this.tail) {
            throw new NoSuchElementException();
        }
        long result = this.elements[this.head];
        this.elements[this.head] = 0L;
        this.head = this.head == this.elements.length - 1 ? 0 : this.head + 1;
        return result;
    }

    @Override
    public boolean removeFirstOccurrenceAsLong(long o) {
        int index = this.firstIndexOfAsLong(o);
        if (index != -1) {
            this.removeAt(index);
            return true;
        }
        return false;
    }

    @Override
    public long removeLastAsLong() {
        if (this.head == this.tail) {
            throw new NoSuchElementException();
        }
        this.tail = this.tail == 0 ? this.elements.length - 1 : this.tail - 1;
        long result = this.elements[this.tail];
        this.elements[this.tail] = 0L;
        return result;
    }

    @Override
    public boolean removeLastOccurrenceAsLong(long o) {
        int index = this.lastIndexOfAsLong((int)o);
        if (index != -1) {
            this.removeAt(index);
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        return this.tail - this.head & this.elements.length - 1;
    }

    @Override
    public @NonNull String toString() {
        Iterator<Long> it = this.iterator();
        if (!it.hasNext()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        while (true) {
            Long e = it.next();
            sb.append(e);
            if (!it.hasNext()) {
                return sb.append(']').toString();
            }
            sb.append(',').append(' ');
        }
    }

    private class DeqIterator
    implements Iterator<Long> {
        private final int fence;
        private int cursor;

        private DeqIterator() {
            this.fence = LongArrayDeque.this.tail;
            this.cursor = LongArrayDeque.this.head;
        }

        @Override
        public boolean hasNext() {
            return this.cursor != this.fence;
        }

        @Override
        public Long next() {
            if (this.cursor == this.fence) {
                throw new NoSuchElementException();
            }
            long result = LongArrayDeque.this.elements[this.cursor];
            if (LongArrayDeque.this.tail != this.fence) {
                throw new ConcurrentModificationException();
            }
            this.cursor = this.cursor + 1 & LongArrayDeque.this.elements.length - 1;
            return result;
        }
    }
}

