/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.collection.spliterator;

import java.util.Objects;
import java.util.Spliterator;
import java.util.function.Consumer;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.collection.spliterator.AbstractListIteratorSpliterator;
import org.jhotdraw8.icollection.readonly.ReadOnlyList;

public class ReadOnlyListSpliterator<E>
extends AbstractListIteratorSpliterator<E> {
    private final @NonNull ReadOnlyList<E> list;
    private int index;
    private final int size;

    public ReadOnlyListSpliterator(@NonNull ReadOnlyList<E> list) {
        this(list, 0, list.size());
    }

    public ReadOnlyListSpliterator(@NonNull ReadOnlyList<E> list, int index, int size) {
        this.list = list;
        this.size = size;
        this.index = index;
    }

    @Override
    public boolean hasNext() {
        return this.index < this.getSize();
    }

    private int getSize() {
        return this.size;
    }

    @Override
    public E next() {
        return (E)this.list.get(this.index++);
    }

    @Override
    public boolean hasPrevious() {
        return this.index > 0;
    }

    @Override
    public E previous() {
        return (E)this.list.get(--this.index);
    }

    @Override
    public int nextIndex() {
        return this.index;
    }

    @Override
    public int previousIndex() {
        return this.index - 1;
    }

    @Override
    public boolean tryAdvance(@Nullable Consumer<? super E> action) {
        Objects.requireNonNull(action, "action");
        if (this.index >= 0 && this.index < this.getSize()) {
            action.accept(this.list.get(this.index++));
            return true;
        }
        return false;
    }

    @Override
    public @Nullable Spliterator<E> trySplit() {
        ReadOnlyListSpliterator<E> readOnlyListSpliterator;
        int lo = this.index;
        int mid = lo + this.getSize() >>> 1;
        if (lo >= mid) {
            readOnlyListSpliterator = null;
        } else {
            this.index = mid;
            ReadOnlyListSpliterator<E> readOnlyListSpliterator2 = new ReadOnlyListSpliterator<E>(this.list, lo, this.index);
            readOnlyListSpliterator = readOnlyListSpliterator2;
        }
        return readOnlyListSpliterator;
    }

    @Override
    public long estimateSize() {
        return this.getSize() - this.index;
    }
}

