/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.collection.util;

import java.lang.reflect.Array;
import java.util.Arrays;
import org.jhotdraw8.annotation.NonNull;

public class ListHelper {
    private ListHelper() {
    }

    public static <T> @NonNull T @NonNull [] copyAddAll(@NonNull T @NonNull [] src, int index, @NonNull T @NonNull [] values) {
        T[] dst = ListHelper.copyComponentAdd(src, index, values.length);
        System.arraycopy(values, 0, dst, index, values.length);
        return dst;
    }

    public static <T> @NonNull T @NonNull [] copyComponentAdd(@NonNull T @NonNull [] src, int index, int numComponents) {
        if (index == src.length) {
            return Arrays.copyOf(src, src.length + numComponents);
        }
        Object[] dst = (Object[])Array.newInstance(src.getClass().getComponentType(), src.length + numComponents);
        System.arraycopy(src, 0, dst, 0, index);
        System.arraycopy(src, index, dst, index + numComponents, src.length - index);
        return dst;
    }

    public static <T> @NonNull T @NonNull [] copyComponentRemove(@NonNull T @NonNull [] src, int index, int numComponents) {
        if (index == src.length - numComponents) {
            return Arrays.copyOf(src, src.length - numComponents);
        }
        Object[] dst = (Object[])Array.newInstance(src.getClass().getComponentType(), src.length - numComponents);
        System.arraycopy(src, 0, dst, 0, index);
        System.arraycopy(src, index + numComponents, dst, index, src.length - index - numComponents);
        return dst;
    }

    public static <T> @NonNull T @NonNull [] copySet(@NonNull T @NonNull [] src, int index, T value) {
        T[] dst = Arrays.copyOf(src, src.length);
        dst[index] = value;
        return dst;
    }

    public static @NonNull Object @NonNull [] grow(int targetCapacity, int itemSize, @NonNull Object @NonNull [] items) {
        if (targetCapacity * itemSize <= items.length) {
            return items;
        }
        int newLength = Integer.max(targetCapacity * itemSize, items.length * 2);
        return Arrays.copyOf(items, newLength, items.getClass());
    }

    public static double @NonNull [] grow(int targetCapacity, int itemSize, double @NonNull [] items) {
        if (targetCapacity * itemSize <= items.length) {
            return items;
        }
        int newLength = Integer.max(targetCapacity * itemSize, items.length * 2);
        return Arrays.copyOf(items, newLength);
    }

    public static byte @NonNull [] grow(int targetCapacity, int itemSize, byte @NonNull [] items) {
        if (targetCapacity * itemSize <= items.length) {
            return items;
        }
        int newLength = Integer.max(targetCapacity * itemSize, items.length * 2);
        return Arrays.copyOf(items, newLength);
    }

    public static short @NonNull [] grow(int targetCapacity, int itemSize, short @NonNull [] items) {
        if (targetCapacity * itemSize <= items.length) {
            return items;
        }
        int newLength = Integer.max(targetCapacity * itemSize, items.length * 2);
        return Arrays.copyOf(items, newLength);
    }

    public static int @NonNull [] grow(int targetCapacity, int itemSize, int @NonNull [] items) {
        if (targetCapacity * itemSize <= items.length) {
            return items;
        }
        int newLength = Integer.max(targetCapacity * itemSize, items.length * 2);
        return Arrays.copyOf(items, newLength);
    }

    public static long @NonNull [] grow(int targetCapacity, int itemSize, long @NonNull [] items) {
        if (targetCapacity * itemSize <= items.length) {
            return items;
        }
        int newLength = Integer.max(targetCapacity * itemSize, items.length * 2);
        return Arrays.copyOf(items, newLength);
    }

    public static char @NonNull [] grow(int targetCapacity, int itemSize, char @NonNull [] items) {
        if (targetCapacity * itemSize <= items.length) {
            return items;
        }
        int newLength = Integer.max(targetCapacity * itemSize, items.length * 2);
        return Arrays.copyOf(items, newLength);
    }

    public static @NonNull Object @NonNull [] trimToSize(int size, int itemSize, @NonNull Object @NonNull [] items) {
        int newLength = size * itemSize;
        if (items.length == newLength) {
            return items;
        }
        return Arrays.copyOf(items, newLength);
    }

    public static int @NonNull [] trimToSize(int size, int itemSize, int @NonNull [] items) {
        int newLength = size * itemSize;
        if (items.length == newLength) {
            return items;
        }
        return Arrays.copyOf(items, newLength);
    }

    public static long @NonNull [] trimToSize(int size, int itemSize, long @NonNull [] items) {
        int newLength = size * itemSize;
        if (items.length == newLength) {
            return items;
        }
        return Arrays.copyOf(items, newLength);
    }

    public static double @NonNull [] trimToSize(int size, int itemSize, double @NonNull [] items) {
        int newLength = size * itemSize;
        if (items.length == newLength) {
            return items;
        }
        return Arrays.copyOf(items, newLength);
    }

    public static byte @NonNull [] trimToSize(int size, int itemSize, byte @NonNull [] items) {
        int newLength = size * itemSize;
        if (items.length == newLength) {
            return items;
        }
        return Arrays.copyOf(items, newLength);
    }
}

