/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.collection.enumerator;

import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.IntConsumer;
import java.util.function.LongConsumer;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.collection.enumerator.BareEnumerator;

public interface Enumerator<E>
extends BareEnumerator<E>,
Spliterator<E> {
    @Override
    default public boolean tryAdvance(@NonNull Consumer<? super E> action) {
        if (this.moveNext()) {
            action.accept(this.current());
            return true;
        }
        return false;
    }

    public static interface OfInt
    extends Enumerator<Integer>,
    Spliterator.OfInt {
        @Override
        default public @NonNull Integer current() {
            return this.currentAsInt();
        }

        public int currentAsInt();

        @Override
        default public boolean tryAdvance(@NonNull IntConsumer action) {
            if (this.moveNext()) {
                action.accept(this.currentAsInt());
                return true;
            }
            return false;
        }

        @Override
        default public boolean tryAdvance(@NonNull Consumer<? super Integer> action) {
            return Enumerator.super.tryAdvance(action);
        }
    }

    public static interface OfDouble
    extends Enumerator<Double>,
    Spliterator.OfDouble {
        @Override
        default public @NonNull Double current() {
            return this.currentAsDouble();
        }

        public double currentAsDouble();

        @Override
        default public boolean tryAdvance(@NonNull DoubleConsumer action) {
            if (this.moveNext()) {
                action.accept(this.currentAsDouble());
                return true;
            }
            return false;
        }

        @Override
        default public boolean tryAdvance(@NonNull Consumer<? super Double> action) {
            return Enumerator.super.tryAdvance(action);
        }
    }

    public static interface OfLong
    extends Enumerator<Long>,
    Spliterator.OfLong {
        @Override
        default public @NonNull Long current() {
            return this.currentAsLong();
        }

        public long currentAsLong();

        @Override
        default public boolean tryAdvance(@NonNull LongConsumer action) {
            if (this.moveNext()) {
                action.accept(this.currentAsLong());
                return true;
            }
            return false;
        }

        @Override
        default public boolean tryAdvance(@NonNull Consumer<? super Long> action) {
            return Enumerator.super.tryAdvance(action);
        }
    }
}

