/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.collection.iterator;

import java.util.ConcurrentModificationException;
import java.util.ListIterator;
import java.util.function.IntSupplier;
import org.jhotdraw8.annotation.NonNull;

public class FailFastListIterator<E>
implements ListIterator<E> {
    private final @NonNull ListIterator<E> i;
    private int expectedModCount;
    private final @NonNull IntSupplier modCountSupplier;
    private final @NonNull Runnable removeFunction;

    public FailFastListIterator(@NonNull ListIterator<E> i, @NonNull IntSupplier modCountSupplier) {
        this(i, modCountSupplier, i::remove);
    }

    public FailFastListIterator(@NonNull ListIterator<E> i, @NonNull IntSupplier modCountSupplier, @NonNull Runnable removeFunction) {
        this.i = i;
        this.modCountSupplier = modCountSupplier;
        this.expectedModCount = modCountSupplier.getAsInt();
        this.removeFunction = removeFunction;
    }

    @Override
    public boolean hasNext() {
        this.ensureUnmodified();
        return this.i.hasNext();
    }

    @Override
    public E next() {
        this.ensureUnmodified();
        return this.i.next();
    }

    @Override
    public boolean hasPrevious() {
        this.ensureUnmodified();
        return this.i.hasPrevious();
    }

    @Override
    public E previous() {
        this.ensureUnmodified();
        return this.i.previous();
    }

    @Override
    public int nextIndex() {
        this.ensureUnmodified();
        return this.i.nextIndex();
    }

    @Override
    public int previousIndex() {
        this.ensureUnmodified();
        return this.i.previousIndex();
    }

    protected void ensureUnmodified() {
        if (this.expectedModCount != this.modCountSupplier.getAsInt()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void remove() {
        this.ensureUnmodified();
        this.removeFunction.run();
        this.expectedModCount = this.modCountSupplier.getAsInt();
    }

    @Override
    public void set(E e) {
        this.ensureUnmodified();
        this.i.set(e);
        this.expectedModCount = this.modCountSupplier.getAsInt();
    }

    @Override
    public void add(E e) {
        this.ensureUnmodified();
        this.i.add(e);
        this.expectedModCount = this.modCountSupplier.getAsInt();
    }
}

