/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.collection.primitive;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Spliterators;
import java.util.function.LongPredicate;
import java.util.stream.LongStream;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.collection.util.ListHelper;

public class LongArrayList
extends AbstractList<Long> {
    private static final long[] EMPTY = new long[0];
    private long[] items;
    private int size;

    public LongArrayList() {
        this.items = EMPTY;
    }

    public LongArrayList(int initialCapacity) {
        this.items = new long[initialCapacity];
    }

    public LongArrayList(@NonNull Collection<Long> collection) {
        this.size = collection.size();
        this.items = new long[this.size];
        int count = 0;
        for (Long value : collection) {
            this.items[count++] = value;
        }
    }

    private LongArrayList(long @NonNull [] items) {
        this.items = items;
        this.size = items.length;
    }

    public static @NonNull LongArrayList of(long ... items) {
        return new LongArrayList(items);
    }

    public void addAsLong(long newItem) {
        this.grow(this.size + 1);
        this.items[this.size++] = newItem;
    }

    public void addAsLong(int index, long newItem) {
        Objects.checkIndex(index, this.size + 1);
        this.grow(this.size + 1);
        this.items[index] = newItem;
        ++this.size;
    }

    public void addAllAsLong(@NonNull LongArrayList that) {
        if (that.isEmpty()) {
            return;
        }
        this.grow(this.size + that.size);
        System.arraycopy(that.items, 0, this.items, this.size, that.size);
        this.size += that.size;
    }

    public <T extends Collection<Long>> @NonNull T addAllInto(@NonNull T out) {
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            out.add(this.items[i]);
        }
        return out;
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    public void copyInto(long @NonNull [] a, int offset) {
        System.arraycopy(this.items, 0, a, offset, this.size);
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LongArrayList other = (LongArrayList)obj;
        if (other.size != this.size) {
            return false;
        }
        for (int i = 0; i < this.size; ++i) {
            if (other.items[i] == this.items[i]) continue;
            return false;
        }
        return true;
    }

    public long getAsLong(int index) {
        Objects.checkIndex(index, this.size);
        return this.items[index];
    }

    @Override
    public Long get(int index) {
        Objects.checkIndex(index, this.size);
        return this.items[index];
    }

    public long getLastAsLong() {
        return this.getAsLong(this.size - 1);
    }

    public long getFirstAsLong() {
        return this.getAsLong(0);
    }

    public void setSize(int newSize) {
        this.grow(newSize);
        if (newSize > this.size) {
            Arrays.fill(this.items, this.size, newSize, 0L);
        }
        this.size = newSize;
    }

    @Override
    public int hashCode() {
        int result = 1;
        for (int i = 0; i < this.size; ++i) {
            result = 31 * result + Long.hashCode(this.items[i]);
        }
        return result;
    }

    private void grow(int capacity) {
        if (this.items.length < capacity) {
            this.items = ListHelper.grow(Math.max(1, this.items.length * 2), 1, this.items);
        }
    }

    public int indexOfAsLong(long item) {
        return this.indexOfAsLong(item, 0);
    }

    public int indexOfAsLong(long item, int start) {
        for (int i = start; i < this.size; ++i) {
            if (this.items[i] != item) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOfAsLong(long item) {
        return this.lastIndexOfAsLong(item, this.size - 1);
    }

    public int lastIndexOfAsLong(long item, int start) {
        for (int i = start; i >= 0; --i) {
            if (this.items[i] != item) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof Long) {
            int e = (Integer)o;
            return this.indexOfAsLong(e) != -1;
        }
        return false;
    }

    public long removeAtAsLong(int index) {
        Objects.checkIndex(index, this.size);
        long removedItem = this.items[index];
        int numMoved = this.size - index - 1;
        if (numMoved > 0) {
            System.arraycopy(this.items, index + 1, this.items, index, numMoved);
        }
        --this.size;
        return removedItem;
    }

    public long removeLastAsLong() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("List is empty.");
        }
        return this.removeAtAsLong(this.size - 1);
    }

    public long setAsLong(int index, long newItem) {
        Objects.checkIndex(index, this.size);
        long removedItem = this.items[index];
        this.items[index] = newItem;
        return removedItem;
    }

    @Override
    public int size() {
        return this.size;
    }

    public void trimToSize() {
        this.items = ListHelper.trimToSize(this.size, 1, this.items);
    }

    public  @NonNull PrimitiveIterator.OfLong iterator() {
        return Spliterators.iterator(this.spliterator());
    }

    public  @NonNull Spliterator.OfLong spliterator() {
        return Spliterators.spliterator(this.items, 0, this.size, 1104);
    }

    public @NonNull LongStream longStream() {
        return this.size == 0 ? LongStream.empty() : Arrays.stream(this.items, 0, this.size);
    }

    public long @NonNull [] toLongArray() {
        long[] result = new long[this.size];
        System.arraycopy(this.items, 0, result, 0, this.size);
        return result;
    }

    @Override
    public boolean add(Long e) {
        this.addAsLong(e);
        return true;
    }

    @Override
    public boolean remove(Object o) {
        int index;
        if (o instanceof Long && (index = this.indexOfAsLong(((Integer)o).intValue())) != -1) {
            this.removeAtAsLong(index);
            return true;
        }
        return false;
    }

    @Override
    public @NonNull String toString() {
        StringBuilder b = new StringBuilder();
        b.append('[');
        for (int i = 0; i < this.size; ++i) {
            if (i > 0) {
                b.append(", ");
            }
            b.append(this.items[i]);
        }
        return b.append(']').toString();
    }

    public void sort() {
        Arrays.sort(this.items, 0, this.size);
    }

    public boolean removeIfAsLong(@NonNull LongPredicate filter) {
        boolean hasRemoved = false;
        Objects.requireNonNull(filter, "filter");
        for (int i = this.size - 1; i >= 0; --i) {
            if (!filter.test(this.getAsLong(i))) continue;
            this.removeAtAsLong(i);
            hasRemoved = true;
        }
        return hasRemoved;
    }

    @Override
    public void sort(@Nullable Comparator<? super Long> c) {
        if (this.size > 1) {
            if (c == null) {
                Arrays.sort(this.items, 0, this.size);
            } else {
                int i;
                Long[] objects = new Long[this.size];
                for (i = 0; i < this.size; ++i) {
                    objects[i] = this.items[i];
                }
                Arrays.sort(objects, 0, this.size, c);
                for (i = 0; i < this.size; ++i) {
                    this.items[i] = objects[i];
                }
            }
        }
    }
}

