/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.collection.enumerator;

import org.jhotdraw8.collection.enumerator.AbstractIntEnumerator;
import org.jspecify.annotations.Nullable;

public class IntArrayEnumerator
extends AbstractIntEnumerator {
    private final int limit;
    private final int[] a;
    private int index;

    public IntArrayEnumerator(int[] a, int from, int to) {
        super(to - from, 16720);
        this.limit = to;
        this.index = from;
        this.a = a;
    }

    @Override
    public boolean moveNext() {
        if (this.index < this.limit) {
            this.current = this.a[this.index++];
            return true;
        }
        return false;
    }

    @Override
    public long estimateSize() {
        return this.limit - this.index;
    }

    @Override
    public @Nullable IntArrayEnumerator trySplit() {
        IntArrayEnumerator intArrayEnumerator;
        int lo = this.index;
        int mid = lo + this.limit >>> 1;
        if (lo >= mid) {
            intArrayEnumerator = null;
        } else {
            this.index = mid;
            IntArrayEnumerator intArrayEnumerator2 = new IntArrayEnumerator(this.a, lo, this.index);
            intArrayEnumerator = intArrayEnumerator2;
        }
        return intArrayEnumerator;
    }
}

