/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.collection.enumerator;

import org.jhotdraw8.collection.enumerator.AbstractIntEnumerator;
import org.jspecify.annotations.Nullable;

public class IntCharArrayEnumerator
extends AbstractIntEnumerator {
    private final int limit;
    private final char[] arrows;
    private int index;

    public IntCharArrayEnumerator(int lo, int hi, char[] arrows) {
        super(hi - lo, 16720);
        this.limit = hi;
        this.index = lo;
        this.arrows = arrows;
    }

    @Override
    public boolean moveNext() {
        if (this.index < this.limit) {
            this.current = this.arrows[this.index++];
            return true;
        }
        return false;
    }

    @Override
    public long estimateSize() {
        return this.limit - this.index;
    }

    @Override
    public @Nullable IntCharArrayEnumerator trySplit() {
        IntCharArrayEnumerator intCharArrayEnumerator;
        int lo = this.index;
        int mid = lo + this.limit >>> 1;
        if (lo >= mid) {
            intCharArrayEnumerator = null;
        } else {
            this.index = mid;
            IntCharArrayEnumerator intCharArrayEnumerator2 = new IntCharArrayEnumerator(lo, this.index, this.arrows);
            intCharArrayEnumerator = intCharArrayEnumerator2;
        }
        return intCharArrayEnumerator;
    }
}

