/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.collection.mapped;

import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jspecify.annotations.Nullable;

public final class MappedList<E, F>
extends AbstractList<E> {
    private final List<F> backingList;
    private final Function<F, E> mapf;

    public MappedList(List<F> backingList, Function<F, E> mapf) {
        this.backingList = backingList;
        this.mapf = mapf;
    }

    @Override
    public boolean contains(Object o) {
        return this.backingList.contains(o);
    }

    @Override
    public E get(int index) {
        return this.mapf.apply(this.backingList.get(index));
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            private final Iterator<F> i;
            {
                this.i = MappedList.this.backingList.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.i.hasNext();
            }

            @Override
            public E next() {
                return MappedList.this.mapf.apply(this.i.next());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public Spliterator<E> spliterator() {
        class MappingSpliterator
        implements Spliterator<E> {
            private final Spliterator<F> i;

            public MappingSpliterator(Spliterator<F> i) {
                this.i = i;
            }

            @Override
            public boolean tryAdvance(Consumer<? super E> action) {
                return this.i.tryAdvance((? super T f) -> action.accept((Object)MappedList.this.mapf.apply(f)));
            }

            @Override
            public @Nullable Spliterator<E> trySplit() {
                Spliterator fSpliterator = this.i.trySplit();
                return fSpliterator == null ? null : new MappingSpliterator(fSpliterator);
            }

            @Override
            public long estimateSize() {
                return this.i.estimateSize();
            }

            @Override
            public int characteristics() {
                return this.i.characteristics();
            }
        }
        return new MappingSpliterator(this.backingList.spliterator());
    }

    @Override
    public int size() {
        return this.backingList.size();
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return new MappedList<E, F>(this.backingList.subList(fromIndex, toIndex), this.mapf);
    }
}

